/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.internal;

import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.customer.entity.Customer;
import com.bizunited.empower.business.customer.service.CustomerService;
import com.bizunited.empower.business.order.entity.OrderInfo;
import com.bizunited.empower.business.order.entity.OrderProduct;
import com.bizunited.empower.business.order.entity.ReturnAuditLog;
import com.bizunited.empower.business.order.entity.ReturnFile;
import com.bizunited.empower.business.order.entity.ReturnInfo;
import com.bizunited.empower.business.order.entity.ReturnProduct;
import com.bizunited.empower.business.order.enums.ReturnAuditStatus;
import com.bizunited.empower.business.order.repository.ReturnInfoRepository;
import com.bizunited.empower.business.order.service.OrderInfoService;
import com.bizunited.empower.business.order.service.ReturnAuditLogService;
import com.bizunited.empower.business.order.service.ReturnFileService;
import com.bizunited.empower.business.order.service.ReturnInfoService;
import com.bizunited.empower.business.order.service.ReturnProductService;
import com.bizunited.empower.business.order.service.notifier.ReturnCancelledEventListener;
import com.bizunited.empower.business.order.service.strategy.OrderStrategyEvent;
import com.bizunited.empower.business.order.service.strategy.ReturnAbstractLoggedAbleStrategy;
import com.bizunited.empower.business.order.service.strategy.ReturnRoamStrategy;
import com.bizunited.empower.business.order.service.strategy.ReturnStrategyEvent;
import com.bizunited.empower.business.payment.service.PaymentInfoService;
import com.bizunited.empower.business.warehouse.common.enums.WarehouseProductsEnterProductType;
import com.bizunited.empower.business.warehouse.dto.WarehouseProductsEnterDto;
import com.bizunited.empower.business.warehouse.dto.WarehouseProductsEnterProductDto;
import com.bizunited.empower.business.warehouse.entity.WarehouseProductsEnter;
import com.bizunited.empower.business.warehouse.service.WarehouseProductsEnterService;
import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.common.service.redis.RedisMutexService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="_ReturnInfoServiceImpl")
public class ReturnInfoServiceImpl
extends ReturnAbstractLoggedAbleStrategy
implements ReturnInfoService {
    private static final String RETURN_GEN_PREFIX = "TH_RETURN_REPEAT";
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private ReturnInfoRepository returnInfoRepository;
    @Autowired
    private ReturnProductService returnProductService;
    @Autowired
    private ReturnFileService returnFileService;
    @Autowired
    private OrderInfoService orderInfoService;
    @Autowired(required=false)
    private List<ReturnRoamStrategy> returnRoamStrategys;
    @Autowired(required=false)
    private List<ReturnCancelledEventListener> returnCancelledEventListeners;
    @Autowired
    private PaymentInfoService paymentInfoService;
    @Autowired
    private WarehouseProductsEnterService warehouseProductsEnterService;
    @Autowired
    private CustomerService customerService;
    @Autowired
    private ReturnAuditLogService auditLogService;

    @Override
    public String preCreate() {
        String prefix = UUID.randomUUID().toString();
        this.redisMutexService.setMCode(RETURN_GEN_PREFIX, prefix, prefix, 0L);
        return prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public ReturnInfo create(ReturnInfo returnInfo, boolean needPrefix) {
        block6: {
            if (needPrefix) {
                String prefix = returnInfo.getPrefix();
                Validate.notBlank((CharSequence)prefix, (String)"\u9519\u8bef\u7684\u9000\u8d27\u5355\u9884\u6dfb\u52a0\u6807\u8bb0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.redisMutexService.getMCode(RETURN_GEN_PREFIX, prefix)), (String)"\u6ca1\u6709\u53d1\u73b0\u9000\u8d27\u5355\u7684\u9884\u6dfb\u52a0\u6807\u8bb0\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u91cd\u590d\u64cd\u4f5c\u7684\u539f\u56e0!!", (Object[])new Object[0]);
                boolean isLock = false;
                try {
                    isLock = this.redisMutexService.tryLock(prefix, TimeUnit.MILLISECONDS, 1);
                    if (isLock) {
                        this.redisMutexService.setMCode(RETURN_GEN_PREFIX, prefix, prefix, 1L);
                        break block6;
                    }
                    throw new IllegalArgumentException("\u8bf7\u4e0d\u8981\u91cd\u590d\u8fdb\u884c\u9000\u8d27\u5355\u6dfb\u52a0!!");
                }
                finally {
                    if (isLock) {
                        this.redisMutexService.unlock(prefix);
                    }
                }
            }
        }
        ReturnInfo current = this.createForm(returnInfo);
        return current;
    }

    private ReturnInfo createForm(ReturnInfo returnInfo) {
        BigDecimal productTotalPrice;
        BigDecimal totalPrice;
        Validate.notNull((Object)((Object)returnInfo), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Date now = new Date();
        returnInfo.setCreateAccount(SecurityUtils.getUserAccount());
        returnInfo.setCreateTime(now);
        returnInfo.setModifyAccount(SecurityUtils.getUserAccount());
        returnInfo.setModifyTime(now);
        String tenantCode = TenantUtils.getTenantCode();
        returnInfo.setTenantCode(tenantCode);
        returnInfo.setReturnStatus(null);
        returnInfo.setPaymentStatus(1);
        returnInfo.setDeliveryStatus(1);
        returnInfo.setReturnCode(null);
        OrderInfo orderInfo = this.orderValidation(returnInfo);
        if (orderInfo == null || StringUtils.isBlank((CharSequence)orderInfo.getId())) {
            returnInfo.setRelationOrder(false);
            returnInfo.setOrderInfo(null);
        } else {
            returnInfo.setRelationOrder(true);
            returnInfo.setOrderInfo(orderInfo);
        }
        BigDecimal fare = returnInfo.getFare() == null ? BigDecimal.valueOf(0L) : returnInfo.getFare();
        BigDecimal specialPrice = returnInfo.getReturnSpecialPrice() == null ? BigDecimal.valueOf(0L) : returnInfo.getReturnSpecialPrice();
        returnInfo.setFare(fare);
        returnInfo.setReturnSpecialPrice(specialPrice);
        returnInfo.setProductTotalPrice(BigDecimal.valueOf(0L));
        returnInfo.setReturnTotalPrice(BigDecimal.valueOf(0L));
        this.createValidation(returnInfo);
        this.returnInfoRepository.save((Object)returnInfo);
        Set<ReturnProduct> returnProducts = returnInfo.getReturnProducts();
        Map<Object, Object> returnProductsUnitPrices = Maps.newHashMap();
        Validate.isTrue((!CollectionUtils.isEmpty(returnProducts) ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u6307\u5b9a\u9000\u8d27\u5355\u7684\u4e0b\u7684\u4efb\u4f55\u660e\u7ec6\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        returnProductsUnitPrices = returnProducts.stream().filter(item -> item.getGift() == 0).collect(Collectors.toMap(ReturnProduct::getProductSpecificationCode, ReturnProduct::getUnitPrice));
        Validate.isTrue((!CollectionUtils.isEmpty((Map)returnProductsUnitPrices) ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u9000\u8d27\u5355\u65f6\uff0c\u81f3\u5c11\u9700\u8981\u9009\u62e9\u4e00\u6761\u5546\u54c1\u89c4\u683c\u4fe1\u606f\uff08\u975e\u8d60\u54c1\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        for (Object returnProduct : returnProducts) {
            if (returnProduct.getGift() != 0) continue;
            returnProduct.setId(null);
            BigDecimal returnQuantity = returnProduct.getReturnQuantity();
            Validate.isTrue((returnQuantity != null && returnQuantity.floatValue() > 0.0f ? 1 : 0) != 0, (String)"\u5546\u54c1\u89c4\u683c[%s]\u5f55\u5165\u4e86\u9519\u8bef\u7684\u9000\u8d27\u6570\u91cf(\u5fc5\u987b\u5927\u4e8e0)\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{returnProduct.getProductSpecificationCode()});
            BigDecimal newUnitPrice = (BigDecimal)returnProductsUnitPrices.get(returnProduct.getProductSpecificationCode());
            Validate.isTrue((newUnitPrice != null && newUnitPrice.floatValue() >= 0.0f ? 1 : 0) != 0, (String)"\u5546\u54c1\u9000\u8d27\u6570\u91cf[%s]\u5f55\u5165\u4e86\u9519\u8bef\u7684\u9000\u8d27\u5355\u4ef7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{returnProduct.getProductSpecificationCode()});
            BigDecimal subtotalAmount = this.returnProductService.analysisProductsSubtotalAmount((ReturnProduct)((Object)returnProduct));
            returnProduct.setSubtotalAmount(subtotalAmount);
            returnProduct.setReturnInfo(returnInfo);
            this.returnProductService.create((ReturnProduct)((Object)returnProduct));
        }
        for (Object returnProduct : returnProducts) {
            if (returnProduct.getGift() == 0) continue;
            returnProduct.setId(null);
            returnProduct.setUnitPrice(BigDecimal.ZERO);
            returnProduct.setSubtotalAmount(BigDecimal.ZERO);
            returnProduct.setReturnInfo(returnInfo);
            this.returnProductService.create((ReturnProduct)((Object)returnProduct));
        }
        Set<ReturnFile> returnFiles = returnInfo.getReturnFiles();
        if (returnFiles != null) {
            for (ReturnFile returnFile : returnFiles) {
                returnFile.setReturnInfo(returnInfo);
                this.returnFileService.create(returnFile);
            }
        }
        Validate.isTrue(((totalPrice = (productTotalPrice = this.returnProductService.analysisProductsTotal(returnProducts)).subtract(fare).subtract(specialPrice)).floatValue() > 0.0f ? 1 : 0) != 0, (String)"\u9000\u8d27\u5355\u603b\u9000\u8d27\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0!!", (Object[])new Object[0]);
        returnInfo.setProductTotalPrice(productTotalPrice);
        returnInfo.setReturnTotalPrice(totalPrice);
        this.returnInfoRepository.save((Object)returnInfo);
        this.nextReturnStatusById(returnInfo.getId(), ReturnStrategyEvent.BeReviewed);
        return returnInfo;
    }

    private OrderInfo orderValidation(ReturnInfo returnInfo) {
        OrderInfo orderInfo = returnInfo.getOrderInfo();
        if (orderInfo != null && !StringUtils.isBlank((CharSequence)orderInfo.getId())) {
            orderInfo = this.orderInfoService.findDetailsById(orderInfo.getId());
            Validate.notNull((Object)((Object)orderInfo), (String)"\u672a\u627e\u5230\u5173\u8054\u7684\u9000\u8d27\u5355\u4fe1\u606f!!", (Object[])new Object[0]);
            Validate.isTrue((boolean)orderInfo.getOrderStatus().equals(OrderStrategyEvent.Completed.getEventTarget()), (String)"\u5fc5\u987b\u662f\u5df2\u5b8c\u6210\u72b6\u6001\u7684\u8ba2\u5355\u624d\u80fd\u521b\u5efa\u9000\u8d27\u5355\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            this.validateRelationOrderProducts(returnInfo, orderInfo);
        }
        return orderInfo;
    }

    private void validateRelationOrderProducts(ReturnInfo returnInfo, OrderInfo orderInfo) {
        String key;
        Set<ReturnProduct> returnProducts = returnInfo.getReturnProducts();
        Validate.isTrue((!CollectionUtils.isEmpty(returnProducts) ? 1 : 0) != 0, (String)"\u9000\u8d27\u5355\u81f3\u5c11\u9700\u8981\u4e00\u6761\u5546\u54c1\u4fe1\u606f!!", (Object[])new Object[0]);
        Set<ReturnInfo> dbReturnInfos = this.findDetailsByOrderId(orderInfo.getId());
        dbReturnInfos = dbReturnInfos.stream().filter(e -> !ReturnStrategyEvent.Cancelled.getEventTarget().equals(e.getReturnStatus())).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(dbReturnInfos)) {
            return;
        }
        Map<String, BigDecimal> orderInfoProducts = orderInfo.getOrderProducts().stream().collect(Collectors.toMap(e1 -> StringUtils.joinWith((String)",", (Object[])new Object[]{e1.getProductSpecificationCode(), e1.getUnitCode(), e1.getGift()}), OrderProduct::getOrderQuantity));
        HashMap dbReturnInfoProducts = Maps.newHashMap();
        for (ReturnInfo returnInfo2 : dbReturnInfos) {
            Set<ReturnProduct> products = returnInfo2.getReturnProducts();
            for (ReturnProduct product : products) {
                String key2 = StringUtils.joinWith((String)",", (Object[])new Object[]{product.getProductSpecificationCode(), product.getUnitCode(), product.getGift()});
                if (dbReturnInfoProducts.containsKey(key2)) {
                    dbReturnInfoProducts.put(key2, ((BigDecimal)dbReturnInfoProducts.get(key2)).add(product.getReturnQuantity()));
                    continue;
                }
                dbReturnInfoProducts.put(key2, product.getReturnQuantity());
            }
        }
        for (ReturnProduct returnProduct : returnProducts) {
            key = StringUtils.joinWith((String)",", (Object[])new Object[]{returnProduct.getProductSpecificationCode(), returnProduct.getUnitCode(), returnProduct.getGift()});
            if (dbReturnInfoProducts.containsKey(key)) {
                dbReturnInfoProducts.put(key, ((BigDecimal)dbReturnInfoProducts.get(key)).add(returnProduct.getReturnQuantity()));
                continue;
            }
            dbReturnInfoProducts.put(key, returnProduct.getReturnQuantity());
        }
        Validate.isTrue((boolean)orderInfoProducts.keySet().containsAll(dbReturnInfoProducts.keySet()), (String)"\u5f53\u524d\u9000\u8d27\u5355\u542b\u6709\u4e0d\u5c5e\u4e8e\u539f\u8ba2\u5355\u7684\u5546\u54c1\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        for (Map.Entry entry : orderInfoProducts.entrySet()) {
            key = (String)entry.getKey();
            if (!dbReturnInfoProducts.containsKey(key)) continue;
            Validate.isTrue((((BigDecimal)entry.getValue()).compareTo((BigDecimal)dbReturnInfoProducts.get(key)) >= 0 ? 1 : 0) != 0, (String)"\u5f53\u524d[%s]\u5546\u54c1\u7684\u5386\u53f2\u7d2f\u8ba1\u9000\u8d27\u6570\u91cf\u8d85\u8fc7\u539f\u8ba2\u5355\u7684\u5546\u54c1\u6570\u91cf\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{StringUtils.substringBefore((String)key, (String)",")});
        }
    }

    private void createValidation(ReturnInfo returnInfo) {
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)returnInfo.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        returnInfo.setId(null);
        Validate.notBlank((CharSequence)returnInfo.getCustomerCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5ba2\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Set<ReturnProduct> returnProducts = returnInfo.getReturnProducts();
        Validate.isTrue((!CollectionUtils.isEmpty(returnProducts) ? 1 : 0) != 0, (String)"\u9000\u8d27\u5355\u81f3\u5c11\u9700\u8981\u4e00\u6761\u5546\u54c1\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.notNull((Object)returnInfo.getPaymentStatus(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4ed8\u6b3e\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)returnInfo.getAddress(), (String)"\u6dfb\u52a0\u65f6\uff0c\u9000\u8d27\u5355\u6536\u8d27\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)returnInfo.getPhone(), (String)"\u6dfb\u52a0\u65f6\uff0c\u9000\u8d27\u5355\u6536\u8d27\u4eba\u8054\u7cfb\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)returnInfo.getContactPerson(), (String)"\u6dfb\u52a0\u65f6\uff0c\u9000\u8d27\u5355\u6536\u8d27\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((returnInfo.getRemark() == null || returnInfo.getRemark().length() < 255 ? 1 : 0) != 0, (String)"\u5907\u6ce8\u4fe1\u606f,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public ReturnInfo update(ReturnInfo returnInfo) {
        Validate.notNull((Object)((Object)returnInfo), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u9000\u8d27\u5355\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        String currentId = returnInfo.getId();
        Validate.isTrue((!StringUtils.isBlank((CharSequence)currentId) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        ReturnInfo currentReturnInfo = this.returnInfoRepository.findDetailsById(currentId);
        Validate.notNull((Object)((Object)currentReturnInfo), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.modifyValidation(currentReturnInfo), (String)"\u53ea\u6709\u9000\u8d27\u5355\u5904\u4e8e\u201c\u5f85\u5ba1\u6838\u201d\uff0c\u4e14\u201c\u672a\u5b8c\u6210\u201d\u5ba1\u6838\u7684\u60c5\u51b5\u4e0b\uff0c\u624d\u80fd\u8fdb\u884c\u4fee\u6539\uff0c\u5e76\u4e14\u4ed8\u6b3e\u72b6\u6001\u9700\u8981\u4e3a\u201c\u672a\u4ed8\u6b3e\u201d", (Object[])new Object[0]);
        this.updateValidation(returnInfo);
        Date now = new Date();
        currentReturnInfo.setModifyAccount(SecurityUtils.getUserAccount());
        currentReturnInfo.setModifyTime(now);
        currentReturnInfo.setReturnSource(returnInfo.getReturnSource());
        currentReturnInfo.setRemark(returnInfo.getRemark());
        currentReturnInfo.setSaleMan(returnInfo.getSaleMan());
        currentReturnInfo.setAddress(returnInfo.getAddress());
        currentReturnInfo.setContactPerson(returnInfo.getContactPerson());
        currentReturnInfo.setPhone(returnInfo.getPhone());
        OrderInfo orderInfo = this.orderValidation(returnInfo);
        if (orderInfo == null || StringUtils.isBlank((CharSequence)orderInfo.getId())) {
            currentReturnInfo.setRelationOrder(false);
            currentReturnInfo.setOrderInfo(null);
        } else {
            currentReturnInfo.setRelationOrder(true);
            currentReturnInfo.setOrderInfo(orderInfo);
        }
        Set<ReturnProduct> currentProducts = currentReturnInfo.getReturnProducts();
        this.returnProductService.deleteByIds(currentProducts.stream().map(UuidEntity::getId).collect(Collectors.toList()).toArray(new String[0]));
        Set<ReturnProduct> returnProducts = returnInfo.getReturnProducts();
        Map<Object, Object> returnProductsUnitPrices = Maps.newHashMap();
        Validate.isTrue((!CollectionUtils.isEmpty(returnProducts) ? 1 : 0) != 0, (String)"\u4fee\u6539\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u9000\u8d27\u5355\u7684\u4e0b\u7684\u4efb\u4f55\u660e\u7ec6\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        returnProductsUnitPrices = returnProducts.stream().filter(item -> item.getGift() == 0).collect(Collectors.toMap(ReturnProduct::getProductSpecificationCode, ReturnProduct::getUnitPrice));
        for (ReturnProduct returnProduct : returnProducts) {
            returnProduct.setId(null);
            if (returnProduct.getGift() == 0) {
                BigDecimal returnQuantity = returnProduct.getReturnQuantity();
                Validate.isTrue((returnQuantity != null && returnQuantity.floatValue() > 0.0f ? 1 : 0) != 0, (String)"\u4fee\u6539\u65f6\uff0c\u5546\u54c1\u89c4\u683c[%s]\u5f55\u5165\u4e86\u9519\u8bef\u7684\u9000\u8d27\u6570\u91cf(\u5fc5\u987b\u5927\u4e8e0)\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{returnProduct.getProductSpecificationCode()});
                BigDecimal newUnitPrice = (BigDecimal)returnProductsUnitPrices.get(returnProduct.getProductSpecificationCode());
                Validate.isTrue((newUnitPrice != null && newUnitPrice.floatValue() >= 0.0f ? 1 : 0) != 0, (String)"\u4fee\u6539\u65f6\uff0c\u5546\u54c1\u9000\u8d27\u6570\u91cf[%s]\u5f55\u5165\u4e86\u9519\u8bef\u7684\u9000\u8d27\u5355\u4ef7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{returnProduct.getProductSpecificationCode()});
                BigDecimal subtotalAmount = this.returnProductService.analysisProductsSubtotalAmount(returnProduct);
                returnProduct.setSubtotalAmount(subtotalAmount);
            } else {
                returnProduct.setUnitPrice(BigDecimal.ZERO);
                returnProduct.setSubtotalAmount(BigDecimal.ZERO);
            }
            returnProduct.setReturnInfo(returnInfo);
            this.returnProductService.create(returnProduct);
        }
        Set<ReturnFile> currentReturnFiles = currentReturnInfo.getReturnFiles();
        this.returnFileService.deleteByIds(currentReturnFiles.stream().map(UuidEntity::getId).collect(Collectors.toList()).toArray(new String[0]));
        Set<ReturnFile> returnFiles = returnInfo.getReturnFiles();
        if (returnFiles != null) {
            for (ReturnFile returnFile : returnFiles) {
                returnFile.setReturnInfo(currentReturnInfo);
                this.returnFileService.create(returnFile);
            }
        }
        BigDecimal fare = returnInfo.getFare() == null ? BigDecimal.valueOf(0L) : returnInfo.getFare();
        BigDecimal specialPrice = returnInfo.getReturnSpecialPrice() == null ? BigDecimal.valueOf(0L) : returnInfo.getReturnSpecialPrice();
        BigDecimal productTotalPrice = this.returnProductService.analysisProductsTotal(returnProducts);
        BigDecimal totalPrice = productTotalPrice.subtract(fare).subtract(specialPrice);
        totalPrice = totalPrice.floatValue() <= 0.0f ? BigDecimal.valueOf(0L) : totalPrice;
        currentReturnInfo.setFare(fare);
        currentReturnInfo.setReturnSpecialPrice(specialPrice);
        currentReturnInfo.setProductTotalPrice(productTotalPrice);
        currentReturnInfo.setReturnTotalPrice(totalPrice);
        this.returnInfoRepository.saveAndFlush((Object)currentReturnInfo);
        this.paymentInfoService.updateByAssociatedCode(currentReturnInfo.getReturnCode(), totalPrice);
        return currentReturnInfo;
    }

    private void updateValidation(ReturnInfo returnInfo) {
        Set<ReturnProduct> returnProducts = returnInfo.getReturnProducts();
        Validate.isTrue((!CollectionUtils.isEmpty(returnProducts) ? 1 : 0) != 0, (String)"\u4fee\u6539\u65f6\uff0c\u9000\u8d27\u5355\u81f3\u5c11\u9700\u8981\u4e00\u6761\u5546\u54c1\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)returnInfo.getAddress(), (String)"\u4fee\u6539\u65f6\uff0c\u9000\u8d27\u5355\u6536\u8d27\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)returnInfo.getPhone(), (String)"\u4fee\u6539\u65f6\uff0c\u9000\u8d27\u5355\u6536\u8d27\u4eba\u8054\u7cfb\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)returnInfo.getContactPerson(), (String)"\u4fee\u6539\u65f6\uff0c\u9000\u8d27\u5355\u6536\u8d27\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((returnInfo.getRemark() == null || returnInfo.getRemark().length() < 255 ? 1 : 0) != 0, (String)"\u5907\u6ce8\u4fe1\u606f,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private boolean modifyValidation(ReturnInfo returnInfo) {
        Integer orderStatus = returnInfo.getReturnStatus();
        Set<ReturnAuditLog> auditLogs = returnInfo.getReturnAuditLogs();
        String auditStatus = null;
        if (!CollectionUtils.isEmpty(auditLogs)) {
            auditStatus = auditLogs.iterator().next().getAuditStatus();
        }
        Integer paymentStatus = returnInfo.getPaymentStatus();
        return orderStatus == 1 && !ReturnAuditStatus.match(auditStatus, ReturnAuditStatus.DONE) && paymentStatus == 1;
    }

    @Override
    @Transactional
    public ReturnInfo cancel(String returnCode) {
        Validate.notBlank((CharSequence)returnCode, (String)"\u672a\u6307\u5b9a\u8981\u4f5c\u5e9f\u7684\u9000\u8d27\u5355\u4e1a\u52a1\u7f16\u53f7!!", (Object[])new Object[0]);
        ReturnInfo current = this.findByReturnCode(returnCode);
        Validate.notNull((Object)((Object)current), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u9000\u8d27\u5355\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        int returnStatus = current.getReturnStatus();
        if (returnStatus == 5) {
            return current;
        }
        Validate.isTrue((boolean)this.modifyValidation(current), (String)"\u53ea\u6709\u9000\u8d27\u5355\u5904\u4e8e\u201c\u5f85\u5ba1\u6838\u201d\uff0c\u4e14\u201c\u672a\u5b8c\u6210\u201d\u5ba1\u6838\u7684\u60c5\u51b5\u4e0b\uff0c\u624d\u80fd\u8fdb\u884c\u4f5c\u5e9f\uff0c\u5e76\u4e14\u4ed8\u6b3e\u72b6\u6001\u4e3a\u201c\u672a\u4ed8\u6b3e\u201d", (Object[])new Object[0]);
        if (this.returnCancelledEventListeners != null) {
            for (ReturnCancelledEventListener listenerItem : this.returnCancelledEventListeners) {
                listenerItem.validate(current);
            }
        }
        current.setReturnStatus(ReturnStrategyEvent.Cancelled.getEventTarget());
        if (this.returnCancelledEventListeners != null) {
            for (ReturnCancelledEventListener listenerItem : this.returnCancelledEventListeners) {
                listenerItem.onReturnCancel(current);
            }
        }
        this.returnInfoRepository.saveAndFlush((Object)current);
        super.logged(current.getId(), returnStatus, ReturnStrategyEvent.Cancelled.getEventTarget());
        return current;
    }

    private ReturnInfo findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.returnInfoRepository.findDetailsById(id);
    }

    @Override
    @Transactional
    public ReturnInfo findByReturnCode(String returnCode) {
        if (StringUtils.isBlank((CharSequence)returnCode)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            return null;
        }
        return this.returnInfoRepository.findByReturnCodeAndTenantCode(returnCode, tenantCode);
    }

    @Override
    @Transactional
    public ReturnInfo nextReturnStatus(String returnCode, ReturnStrategyEvent event) {
        Validate.notBlank((CharSequence)returnCode, (String)"\u9519\u8bef\u7684\u9000\u8d27\u5355\u7f16\u53f7\uff08\u9000\u8d27\u5355\u4e1a\u52a1\u7f16\u53f7\uff09\uff0c\u8bf7\u4f20\u5165!!", (Object[])new Object[0]);
        this.validateStrategys();
        ReturnInfo returnInfo = this.findByReturnCode(returnCode);
        Validate.notNull((Object)((Object)returnInfo), (String)"\u672a\u6839\u636e\u6307\u5b9a\u7684\u9000\u8d27\u5355\u7f16\u53f7\uff08\u9000\u8d27\u5355\u4e1a\u52a1\u7f16\u53f7\uff09\uff0c\u627e\u5230\u5bf9\u5e94\u7684\u9000\u8d27\u5355\u57fa\u672c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return this.nextReturnStatusById(returnInfo.getId(), event);
    }

    @Override
    @Transactional
    public ReturnInfo nextReturnStatusById(String id, ReturnStrategyEvent event) {
        Validate.notBlank((CharSequence)id, (String)"\u9519\u8bef\u7684\u9000\u8d27\u5355\u7f16\u53f7\uff08\u9000\u8d27\u5355\u6280\u672f\u7f16\u53f7\uff09\uff0c\u8bf7\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)event), (String)"\u9519\u8bef\u7684\u76ee\u6807\u9000\u8d27\u5355\u72b6\u6001\u6d41\u8f6c\u4e8b\u4ef6!!", (Object[])new Object[0]);
        this.validateStrategys();
        ReturnInfo returnInfo = this.findDetailsById(id);
        Validate.notNull((Object)((Object)returnInfo), (String)"\u672a\u6839\u636e\u6307\u5b9a\u7684\u9000\u8d27\u5355\u7f16\u53f7\uff08\u9000\u8d27\u5355\u6280\u672f\u7f16\u53f7\uff09\uff0c\u627e\u5230\u5bf9\u5e94\u7684\u9000\u8d27\u5355\u57fa\u672c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        ReturnRoamStrategy currentStrategy = null;
        if (this.returnRoamStrategys != null) {
            for (ReturnRoamStrategy strategyItem : this.returnRoamStrategys) {
                ReturnStrategyEvent strategyEvent = strategyItem.manualValidate();
                if (strategyEvent != event) continue;
                currentStrategy = strategyItem;
                break;
            }
        }
        Validate.notNull(currentStrategy, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u9000\u8d27\u5355\u6d41\u8f6c\u7b56\u7565[%s]", (Object[])new Object[]{event.getEventName()});
        currentStrategy.action(returnInfo);
        return this.nextReturnStatus(returnInfo.getReturnCode());
    }

    @Override
    public ReturnInfo nextReturnStatus(String returnCode) {
        ReturnInfo current = this.findByReturnCode(returnCode);
        Validate.notNull((Object)((Object)current), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u9000\u8d27\u5355\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.validateStrategys();
        ReturnRoamStrategy previousStrategy = null;
        while (true) {
            ReturnRoamStrategy foundStrategy = null;
            for (int index = 0; this.returnRoamStrategys != null && index < this.returnRoamStrategys.size(); ++index) {
                ReturnRoamStrategy returnRoamStrategy = this.returnRoamStrategys.get(index);
                if (!returnRoamStrategy.automaticValidate(current).booleanValue()) continue;
                foundStrategy = returnRoamStrategy;
                break;
            }
            if (foundStrategy == null || previousStrategy == foundStrategy) break;
            foundStrategy.action(current);
            previousStrategy = foundStrategy;
        }
        return current;
    }

    @Override
    public long countByReturnStatus(Integer returnStatus) {
        if (returnStatus == null) {
            return 0L;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return this.returnInfoRepository.countByTenantCodeAndReturnStatus(tenantCode, returnStatus);
    }

    @Override
    @Transactional
    public void audit(String returnCode, String auditStatus, String comments) {
        Validate.notBlank((CharSequence)returnCode, (String)"\u5ba1\u6838\u65f6\uff0c\u9000\u8d27\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditStatus, (String)"\u5ba1\u6838\u65f6\uff0c\u5ba1\u6838\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ReturnInfo returnInfo = this.findByReturnCode(returnCode);
        Validate.notNull((Object)((Object)returnInfo), (String)"\u6839\u636e\u9000\u8d27\u5355\u7f16\u7801\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u9000\u8d27\u5355\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((returnInfo.getReturnStatus() == 1 ? 1 : 0) != 0, (String)"\u5ba1\u6838\u64cd\u4f5c\u65f6\uff0c\u9000\u8d27\u5355\u72b6\u6001\u5fc5\u987b\u4e3a\u5ba1\u6838\u72b6\u6001", (Object[])new Object[0]);
        Validate.isTrue((boolean)ReturnAuditStatus.match(auditStatus), (String)"\u4f20\u5165\u7684\u5ba1\u6838\u72b6\u6001\u503c\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        ReturnAuditLog auditLog = new ReturnAuditLog();
        auditLog.setAuditStatus(auditStatus);
        auditLog.setAuditComments(comments);
        auditLog.setAuditVersion("1.0.0");
        auditLog.setReturnInfo(returnInfo);
        this.auditLogService.create(auditLog);
        if (ReturnAuditStatus.match(auditStatus, ReturnAuditStatus.DONE)) {
            this.nextReturnStatusById(returnInfo.getId(), ReturnStrategyEvent.BeReceived);
        } else {
            this.cancel(returnCode);
        }
    }

    @Override
    @Transactional
    public void receive(String returnCode, String warehouseCode) {
        Validate.notBlank((CharSequence)returnCode, (String)"\u4f20\u5165\u7684\u9000\u8d27\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ReturnInfo returnInfo = this.findByReturnCode(returnCode);
        Validate.notNull((Object)((Object)returnInfo), (String)"\u6839\u636e\u63d0\u4f9b\u7684\u9000\u8d27\u5355\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u7684\u9000\u8d27\u5355\u4fe1\u606f", (Object[])new Object[]{returnCode});
        Set<ReturnAuditLog> auditLogs = returnInfo.getReturnAuditLogs();
        Validate.isTrue((!CollectionUtils.isEmpty(auditLogs) && ReturnAuditStatus.match(auditLogs.iterator().next().getAuditStatus(), ReturnAuditStatus.DONE) ? 1 : 0) != 0, (String)"\u53ea\u6709\u5ba1\u6838\u901a\u8fc7\u7684\u9000\u8d27\u5355\uff0c\u624d\u80fd\u8fdb\u884c\u6536\u8d27\u64cd\u4f5c", (Object[])new Object[0]);
        Validate.isTrue((returnInfo.getDeliveryStatus() == 1 ? 1 : 0) != 0, (String)"\u672a\u6536\u8d27\u7684\u9000\u8d27\u5355\uff0c\u624d\u80fd\u8fdb\u884c\u6536\u8d27\u64cd\u4f5c", (Object[])new Object[0]);
        Customer customer = this.customerService.findByTenantCodeAndCustomerCode(TenantUtils.getTenantCode(), returnInfo.getCustomerCode());
        Validate.notNull((Object)customer, (String)"\u6839\u636e\u8ba2\u5355\u4e2d\u7684\u5ba2\u6237\u4e1a\u52a1\u7f16\u53f7[%s]\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5ba2\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{returnInfo.getCustomerCode()});
        WarehouseProductsEnterDto warehouseProductsEnter = new WarehouseProductsEnterDto();
        warehouseProductsEnter.setRelevanceCode(returnInfo.getReturnCode());
        warehouseProductsEnter.setRemark(returnInfo.getRemark());
        warehouseProductsEnter.setSupplierCustomerCode(returnInfo.getCustomerCode());
        warehouseProductsEnter.setSupplierCustomerName(customer.getCustomerName());
        warehouseProductsEnter.setType(Integer.valueOf(2));
        warehouseProductsEnter.setWarehouseCode(warehouseCode);
        Set<ReturnProduct> returnProducts = returnInfo.getReturnProducts();
        Validate.isTrue((!CollectionUtils.isEmpty(returnProducts) ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u6307\u5b9a\u9000\u8d27\u5355\u7684\u4e0b\u7684\u4efb\u4f55\u660e\u7ec6\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        HashSet<WarehouseProductsEnterProductDto> warehouseProductsEnterProducts = new HashSet<WarehouseProductsEnterProductDto>();
        for (ReturnProduct returnProduct : returnProducts) {
            WarehouseProductsEnterProductDto warehouseProductsEnterProduct = new WarehouseProductsEnterProductDto();
            warehouseProductsEnterProduct.setPrice(returnProduct.getUnitPrice());
            warehouseProductsEnterProduct.setProductSpecificationCode(returnProduct.getProductSpecificationCode());
            warehouseProductsEnterProduct.setRelevanceDetailCode(returnProduct.getId());
            warehouseProductsEnterProduct.setQuantity(returnProduct.getReturnQuantity());
            warehouseProductsEnterProduct.setRemark(returnProduct.getRemark());
            warehouseProductsEnterProduct.setUnitCode(returnProduct.getUnitCode());
            warehouseProductsEnterProduct.setType(returnProduct.getGift() == 1 ? WarehouseProductsEnterProductType.GIFT.getType() : WarehouseProductsEnterProductType.BUY.getType());
            warehouseProductsEnterProducts.add(warehouseProductsEnterProduct);
        }
        warehouseProductsEnter.setProducts(warehouseProductsEnterProducts);
        WarehouseProductsEnter enter = this.warehouseProductsEnterService.create(warehouseProductsEnter);
        this.warehouseProductsEnterService.confirmEnter(enter.getEnterCode(), warehouseCode);
        if (returnInfo.getPaymentStatus() == 3) {
            returnInfo.setReturnStatus(ReturnStrategyEvent.BeRefunded.getEventTarget());
            this.returnInfoRepository.saveAndFlush((Object)returnInfo);
            this.nextReturnStatusById(returnInfo.getId(), ReturnStrategyEvent.Completed);
        } else {
            returnInfo.setReturnStatus(ReturnStrategyEvent.BeReceived.getEventTarget());
            this.returnInfoRepository.saveAndFlush((Object)returnInfo);
            this.nextReturnStatusById(returnInfo.getId(), ReturnStrategyEvent.BeRefunded);
        }
    }

    @Override
    public Set<ReturnInfo> findDetailsByOrderId(String orderId) {
        if (StringUtils.isBlank((CharSequence)orderId)) {
            return Sets.newHashSet();
        }
        return this.returnInfoRepository.findDetailsByOrderId(orderId);
    }

    private void validateStrategys() {
        Validate.isTrue((!CollectionUtils.isEmpty(this.returnRoamStrategys) ? 1 : 0) != 0, (String)"\u672a\u53d1\u73b0\u4efb\u4f55\u9000\u8d27\u5355\u6d41\u8f6c\u7b56\u7565\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
    }
}

