/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.internal;

import com.bizunited.empower.business.customer.entity.Customer;
import com.bizunited.empower.business.customer.service.CustomerService;
import com.bizunited.empower.business.order.dto.ReturnInfoDto;
import com.bizunited.empower.business.order.entity.ReturnInfo;
import com.bizunited.empower.business.order.entity.ReturnProduct;
import com.bizunited.empower.business.order.repository.ReturnInfoRepository;
import com.bizunited.empower.business.order.service.ReturnInfoVoService;
import com.bizunited.empower.business.order.vo.ReturnInfoVo;
import com.bizunited.empower.business.order.vo.ReturnProductVo;
import com.bizunited.empower.business.product.service.ProductSpecificationVoService;
import com.bizunited.empower.business.product.vo.ProductSpecificationVo;
import com.bizunited.empower.business.product.vo.ProductUnitSpecificationAndPriceVo;
import com.bizunited.empower.business.product.vo.ProductUnitVo;
import com.bizunited.empower.business.product.vo.ProductVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="ReturnInfoVoServiceImpl")
public class ReturnInfoVoServiceImpl
implements ReturnInfoVoService {
    @Autowired
    private ReturnInfoRepository returnInfoRepository;
    @Autowired
    private ProductSpecificationVoService productSpecificationVoService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private CustomerService customerService;

    @Override
    public Page<ReturnInfoVo> findByConditions(Pageable pageable, ReturnInfoDto returnInfo) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)20);
        }
        if (returnInfo == null) {
            returnInfo = new ReturnInfoDto();
        }
        String tenantCode = TenantUtils.getTenantCode();
        returnInfo.setTenantCode(tenantCode);
        Page result = this.returnInfoRepository.findByCondition(pageable, returnInfo);
        if (result == null) {
            return null;
        }
        ArrayList<ReturnInfoVo> returnInfos = new ArrayList<ReturnInfoVo>();
        for (Object[] item : result) {
            ReturnInfoVo returnInfoItem = new ReturnInfoVo();
            returnInfoItem.setId(item[0] == null ? null : item[0].toString());
            returnInfoItem.setOrderId(item[1] == null ? null : item[1].toString());
            returnInfoItem.setOrderCode(item[2] == null ? null : item[2].toString());
            returnInfoItem.setReturnCode(item[3] == null ? null : item[3].toString());
            returnInfoItem.setCustomerCode(item[4] == null ? null : item[4].toString());
            returnInfoItem.setCustomerName(item[5] == null ? null : item[5].toString());
            returnInfoItem.setSaleMan(item[6] == null ? null : item[6].toString());
            returnInfoItem.setSaleAccount(item[7] == null ? null : item[7].toString());
            returnInfoItem.setReturnTotalPrice(item[8] == null ? null : (BigDecimal)item[8]);
            returnInfoItem.setReturnStatus(item[9] == null ? null : (Integer)item[9]);
            returnInfoItem.setReturnSource(item[10] == null ? null : item[10].toString());
            returnInfoItem.setCreateTime(item[11] == null ? null : (Date)item[11]);
            returnInfoItem.setCreateAccount(item[12] == null ? null : item[12].toString());
            returnInfoItem.setModifyTime(item[13] == null ? null : (Date)item[13]);
            returnInfoItem.setModifyAccount(item[14] == null ? null : item[14].toString());
            returnInfoItem.setReturnTime(item[15] == null ? null : (Date)item[15]);
            returnInfoItem.setRemark(item[16] == null ? null : item[16].toString());
            returnInfoItem.setPaymentStatus(item[17] == null ? null : (Integer)item[17]);
            returnInfoItem.setTenantCode(item[18] == null ? null : item[18].toString());
            returnInfoItem.setRelevanceUserAccount(item[19] == null ? null : item[19].toString());
            returnInfos.add(returnInfoItem);
        }
        return new PageImpl(returnInfos, pageable, result.getTotalElements());
    }

    @Override
    public ReturnInfoVo findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ReturnInfo currentReturnInfo = this.returnInfoRepository.findDetailsById(id);
        if (currentReturnInfo == null) {
            return null;
        }
        return this.perfection(currentReturnInfo);
    }

    private ReturnInfoVo perfection(ReturnInfo currentReturnInfo) {
        Set<ReturnProduct> returnProducts;
        List productSpecificationCodes;
        List productSpecifications;
        Customer customer;
        String customerCode;
        ReturnInfoVo returnInfoVo = (ReturnInfoVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)currentReturnInfo, ReturnInfoVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"orderInfo", "returnProducts", "returnFiles", "returnStatusLoggers", "returnAuditLogs"}));
        if (currentReturnInfo.getRelationOrder().booleanValue() && currentReturnInfo.getOrderInfo() != null) {
            returnInfoVo.setOrderCode(currentReturnInfo.getOrderInfo().getOrderCode());
            returnInfoVo.setOrderId(currentReturnInfo.getOrderInfo().getId());
        }
        if (!StringUtils.isBlank((CharSequence)(customerCode = currentReturnInfo.getCustomerCode())) && (customer = this.customerService.findByTenantCodeAndCustomerCode(TenantUtils.getTenantCode(), customerCode)) != null) {
            returnInfoVo.setCustomerCode(customer.getCustomerCode());
            returnInfoVo.setCustomerName(customer.getCustomerName());
            returnInfoVo.setRelevanceUserAccount(customer.getRelevanceUserAccount());
        }
        if (CollectionUtils.isEmpty((Collection)(productSpecifications = this.productSpecificationVoService.findBySpecificationCodeList(productSpecificationCodes = (returnProducts = currentReturnInfo.getReturnProducts()).stream().map(ReturnProduct::getProductSpecificationCode).collect(Collectors.toList()))))) {
            return returnInfoVo;
        }
        Set<ReturnProductVo> returnProductVos = returnInfoVo.getReturnProducts();
        for (ReturnProductVo returnProductVoItem : returnProductVos) {
            ProductUnitSpecificationAndPriceVo productUnitAndPriceVo;
            Set productUnitAndPriceVos;
            String productSpecificationCode = returnProductVoItem.getProductSpecificationCode();
            String unitCodetarget = returnProductVoItem.getUnitCode();
            ProductSpecificationVo productSpecificationVo = productSpecifications.stream().filter(item -> StringUtils.equals((CharSequence)productSpecificationCode, (CharSequence)item.getProductSpecificationCode())).findFirst().orElse(null);
            if (productSpecificationVo == null) continue;
            returnProductVoItem.setMainImageName(productSpecificationVo.getMainImageName());
            returnProductVoItem.setMainImagePath(productSpecificationVo.getMainImagePath());
            ProductVo productVo = productSpecificationVo.getProduct();
            if (productVo != null) {
                returnProductVoItem.setProductCode(productVo.getProductCode());
                returnProductVoItem.setProductName(productVo.getProductName());
            }
            if (CollectionUtils.isEmpty((Collection)(productUnitAndPriceVos = productVo.getProductUnitSpecificationAndPrices())) || (productUnitAndPriceVo = (ProductUnitSpecificationAndPriceVo)productUnitAndPriceVos.stream().filter(item -> {
                ProductUnitVo productUnit = item.getProductUnit();
                if (productUnit == null) {
                    return false;
                }
                String unitCode = productUnit.getUnitCode();
                return StringUtils.equals((CharSequence)unitCode, (CharSequence)unitCodetarget);
            }).findFirst().orElse(null)) == null) continue;
            ProductUnitVo productUnit = productUnitAndPriceVo.getProductUnit();
            returnProductVoItem.setUnitName(productUnit.getUnitName());
            returnProductVoItem.setUnitCode(productUnit.getUnitCode());
        }
        return returnInfoVo;
    }

    @Override
    public ReturnInfoVo findDetailsByReturnCode(String returnCode) {
        if (StringUtils.isBlank((CharSequence)returnCode)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            return null;
        }
        ReturnInfo currentReturnInfo = this.returnInfoRepository.findDetailsByReturnCodeAndTenantCode(returnCode, tenantCode);
        if (currentReturnInfo == null) {
            return null;
        }
        return this.perfection(currentReturnInfo);
    }
}

