/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.internal;

import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.order.entity.ReturnProduct;
import com.bizunited.empower.business.order.repository.ReturnProductRepository;
import com.bizunited.empower.business.order.service.ReturnProductService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="_ReturnProductServiceImpl")
public class ReturnProductServiceImpl
implements ReturnProductService {
    @Autowired
    private ReturnProductRepository returnProductRepository;

    @Override
    @Transactional
    public ReturnProduct create(ReturnProduct returnProduct) {
        ReturnProduct current = this.createForm(returnProduct);
        return current;
    }

    @Override
    @Transactional
    public ReturnProduct createForm(ReturnProduct returnProduct) {
        Date now = new Date();
        this.createValidation(returnProduct);
        returnProduct.setCreateAccount(SecurityUtils.getUserAccount());
        returnProduct.setCreateTime(now);
        returnProduct.setModifyAccount(SecurityUtils.getUserAccount());
        returnProduct.setModifyTime(now);
        returnProduct.setSubtotalAmount(BigDecimal.valueOf(0L));
        returnProduct.setTenantCode(TenantUtils.getTenantCode());
        this.returnProductRepository.save((Object)returnProduct);
        return returnProduct;
    }

    private void createValidation(ReturnProduct returnProduct) {
        Validate.notNull((Object)((Object)returnProduct), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)returnProduct.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        returnProduct.setId(null);
        Validate.notNull((Object)((Object)returnProduct.getReturnInfo()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u4fe1\u606f\u4e00\u5b9a\u9700\u8981\u6709\u5bf9\u5e94\u7684\u8ba2\u5355\u4fe1\u606f!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)returnProduct.getProductSpecificationCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\uff08\u89c4\u683c\uff09\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)returnProduct.getProductSpecificationName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\uff08\u89c4\u683c\uff09\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)returnProduct.getUnitCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)returnProduct.getReturnQuantity(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u9000\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((returnProduct.getReturnQuantity().floatValue() > 0.0f ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u9000\u8d27\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        if (returnProduct.getGift() == 0) {
            Validate.notNull((Object)returnProduct.getOldUnitPrice(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u539f\u5546\u54c1\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((returnProduct.getUnitPrice().floatValue() > 0.0f ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8d27\u54c1\u5355\u4f4d\u4ef7\u683c\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        } else {
            returnProduct.setUnitPrice(BigDecimal.valueOf(0L));
        }
        Validate.notNull((Object)returnProduct.getGift(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u662f\u8d60\u54c1\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((returnProduct.getProductSpecificationCode() == null || returnProduct.getProductSpecificationCode().length() < 128 ? 1 : 0) != 0, (String)"\u5546\u54c1\uff08\u89c4\u683c\uff09\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((returnProduct.getProductSpecificationName() == null || returnProduct.getProductSpecificationName().length() < 128 ? 1 : 0) != 0, (String)"\u5546\u54c1\uff08\u89c4\u683c\uff09\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((returnProduct.getInternationalBarcode() == null || returnProduct.getInternationalBarcode().length() < 255 ? 1 : 0) != 0, (String)"\u56fd\u9645\u6761\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((returnProduct.getUnitCode() == null || returnProduct.getUnitCode().length() < 255 ? 1 : 0) != 0, (String)"\u5355\u4f4d,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((returnProduct.getRemark() == null || returnProduct.getRemark().length() < 255 ? 1 : 0) != 0, (String)"\u5907\u6ce8,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public BigDecimal analysisProductsSubtotalAmount(ReturnProduct returnProduct) {
        Validate.notNull((Object)((Object)returnProduct), (String)"\u9700\u8981\u5206\u6790\u5c0f\u8ba1\u4ef7\u683c\u7684\u9000\u8d27\u660e\u7ec6\uff0c\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.isTrue((returnProduct.getGift() == 0 ? 1 : 0) != 0, (String)"\u9700\u8981\u5206\u6790\u5c0f\u8ba1\u4ef7\u683c\u7684\u9000\u8d27\u660e\u7ec6\uff0c\u4e0d\u80fd\u4e3a\u8d60\u54c1!!", (Object[])new Object[0]);
        Validate.notNull((Object)returnProduct.getReturnQuantity(), (String)"\u9000\u8d27\u5355\u5546\u54c1[%s]\u7684\u9000\u8d27\u6570\u91cf\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[]{returnProduct.getProductSpecificationName()});
        BigDecimal returnQuantity = returnProduct.getReturnQuantity();
        Validate.isTrue((returnQuantity.floatValue() >= 0.0f ? 1 : 0) != 0, (String)"\u9000\u8d27\u5355\u5546\u54c1[%s]\u7684\u8ba2\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u8d1f\u6570!", (Object[])new Object[]{returnProduct.getProductSpecificationName()});
        Validate.notNull((Object)returnProduct.getUnitPrice(), (String)"\u9000\u8d27\u5355\u5546\u54c1[%s]\u7684\u9000\u8d27\u5355\u4ef7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[]{returnProduct.getProductSpecificationName()});
        BigDecimal unitPrice = returnProduct.getUnitPrice();
        Validate.isTrue((unitPrice.floatValue() >= 0.0f ? 1 : 0) != 0, (String)"\u9000\u8d27\u5355\u5546\u54c1[%s]\u7684\u8ba2\u8d27\u5355\u4ef7\u4e0d\u80fd\u4e3a\u8d1f\u6570!", (Object[])new Object[]{returnProduct.getProductSpecificationName()});
        BigDecimal subtotalAmount = returnQuantity.multiply(unitPrice).setScale(4, RoundingMode.HALF_UP);
        return subtotalAmount;
    }

    @Override
    public BigDecimal analysisProductsTotal(Set<ReturnProduct> returnProducts) {
        Validate.isTrue((!CollectionUtils.isEmpty(returnProducts) ? 1 : 0) != 0, (String)"\u8fdb\u884c\u9000\u8d27\u5546\u54c1\u8ba1\u7b97\u65f6\uff0c\u5fc5\u987b\u81f3\u5c11\u51fa\u5165\u4e00\u4e2a\u5546\u54c1\u6761\u76ee!!", (Object[])new Object[0]);
        Set effectiveReturnProducts = returnProducts.stream().filter(item -> item.getGift() == 0).collect(Collectors.toSet());
        Set<ReturnProduct> giftReturnProducts = returnProducts.stream().filter(item -> item.getGift() == 1).collect(Collectors.toSet());
        Validate.isTrue((!CollectionUtils.isEmpty(effectiveReturnProducts) ? 1 : 0) != 0, (String)"\u9000\u8d27\u65f6\uff0c\u9000\u8d27\u5355\u4e0a\u81f3\u5c11\u5e94\u8be5\u6709\u4e00\u6761\u975e\u8d60\u54c1\u9000\u8d27\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        BigDecimal total = BigDecimal.valueOf(0L);
        for (ReturnProduct effectiveReturnProduct : effectiveReturnProducts) {
            BigDecimal subtotalAmount = this.analysisProductsSubtotalAmount(effectiveReturnProduct);
            effectiveReturnProduct.setSubtotalAmount(subtotalAmount);
            total = total.add(subtotalAmount);
        }
        if (!CollectionUtils.isEmpty(giftReturnProducts)) {
            giftReturnProducts.forEach(item -> {
                item.setSubtotalAmount(BigDecimal.valueOf(0L));
                item.setUnitPrice(BigDecimal.valueOf(0L));
            });
        }
        return total;
    }

    @Override
    @Transactional
    public void deleteByIds(String[] ids) {
        if (ids == null || ids.length <= 0) {
            return;
        }
        this.returnProductRepository.deleteByIds(ids);
    }

    @Override
    public Set<ReturnProduct> findByOrderCode(String orderCode) {
        if (StringUtils.isBlank((CharSequence)orderCode)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            return null;
        }
        return this.returnProductRepository.findByOrderCodeAndTenantCode(orderCode, tenantCode);
    }
}

