/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.internal;

import com.bizunited.empower.business.order.entity.ReturnInfo;
import com.bizunited.empower.business.order.entity.ReturnStatusLogger;
import com.bizunited.empower.business.order.repository.ReturnStatusLoggerRepository;
import com.bizunited.empower.business.order.service.ReturnStatusLoggerService;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="_ReturnStatusLoggerServiceImpl")
public class ReturnStatusLoggerServiceImpl
implements ReturnStatusLoggerService {
    @Autowired
    private ReturnStatusLoggerRepository returnStatusLoggerRepository;

    @Override
    @Transactional
    public void create(String returnId, String opAccount, Integer previouStatus, Integer currentStatus) {
        Validate.notBlank((CharSequence)returnId, (String)"\u9000\u8d27\u5355\u6280\u672f\u7f16\u53f7\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5\uff01\uff01", (Object[])new Object[0]);
        Validate.isTrue((currentStatus >= 1 && currentStatus <= 6 ? 1 : 0) != 0, (String)"\u4e0d\u5408\u6cd5\u7684\u9000\u8d27\u5355\u6d41\u8f6c\u72b6\u6001\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        ReturnStatusLogger logger = new ReturnStatusLogger();
        logger.setCurrentStatus(currentStatus);
        logger.setLoggerTime(new Date());
        logger.setPreviouStatus(previouStatus);
        logger.setOpAccount(opAccount);
        ReturnInfo currrentReturn = new ReturnInfo();
        currrentReturn.setId(returnId);
        logger.setReturnInfo(currrentReturn);
        this.createForm(logger);
    }

    private ReturnStatusLogger createForm(ReturnStatusLogger logger) {
        this.createValidation(logger);
        this.returnStatusLoggerRepository.save((Object)logger);
        return logger;
    }

    private void createValidation(ReturnStatusLogger logger) {
        Validate.notNull((Object)((Object)logger), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)logger.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        logger.setId(null);
        Validate.notNull((Object)logger.getLoggerTime(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u64cd\u4f5c\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)logger.getCurrentStatus(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u524d\u9000\u8d27\u5355\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((logger.getOpAccount() == null || logger.getOpAccount().length() < 255 ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u8005\u8d26\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public Set<ReturnStatusLogger> findDetailsByReturnInfo(String returnInfo) {
        if (StringUtils.isBlank((CharSequence)returnInfo)) {
            return Sets.newHashSet();
        }
        return this.returnStatusLoggerRepository.findDetailsByReturnInfo(returnInfo);
    }
}

