/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.notifier;

import com.bizunited.empower.business.distribution.entity.DeliverGood;
import com.bizunited.empower.business.distribution.enums.DeliverStatus;
import com.bizunited.empower.business.distribution.service.DeliverGoodVoService;
import com.bizunited.empower.business.distribution.service.listener.DeliverGoodListener;
import com.bizunited.empower.business.order.entity.OrderInfo;
import com.bizunited.empower.business.order.service.OrderInfoService;
import com.bizunited.empower.business.order.service.strategy.OrderStrategyEvent;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeliverGoodEventForOrderListenerImpl
implements DeliverGoodListener {
    @Autowired
    private DeliverGoodVoService deliverGoodVoService;
    @Autowired
    private OrderInfoService orderInfoService;

    public void onCreate(DeliverGood deliverGood) {
    }

    public void deliverGood(DeliverGood deliverGood) {
        OrderInfo orderInfo = this.validatePrefix(deliverGood);
        if (orderInfo == null || !OrderStrategyEvent.BeShipped.getEventTarget().equals(orderInfo.getOrderStatus()) && !OrderStrategyEvent.PartialShipped.getEventTarget().equals(orderInfo.getOrderStatus())) {
            return;
        }
        List deliverGoodVos = this.deliverGoodVoService.findByOrderCode(orderInfo.getOrderCode());
        deliverGoodVos = deliverGoodVos.stream().filter(e -> !DeliverStatus.CANCEL.getType().equals(e.getDeliverStatus())).collect(Collectors.toList());
        boolean hasWaitDeliver = deliverGoodVos.stream().anyMatch(e -> DeliverStatus.WAIT_DELIVER.getType().equals(e.getDeliverStatus()));
        if (OrderStrategyEvent.BeShipped.getEventTarget().equals(orderInfo.getOrderStatus())) {
            if (hasWaitDeliver) {
                this.orderInfoService.nextOrderStatus(deliverGood.getOrderCode(), OrderStrategyEvent.PartialShipped);
            } else {
                this.orderInfoService.nextOrderStatus(deliverGood.getOrderCode(), OrderStrategyEvent.BeReceived);
            }
            return;
        }
        if (OrderStrategyEvent.PartialShipped.getEventTarget().equals(orderInfo.getOrderStatus()) && !hasWaitDeliver) {
            this.orderInfoService.nextOrderStatus(deliverGood.getOrderCode(), OrderStrategyEvent.BeReceived);
        }
    }

    public void onReceiving(DeliverGood deliverGood) {
        OrderInfo orderInfo = this.validatePrefix(deliverGood);
        if (orderInfo == null || !OrderStrategyEvent.BeReceived.getEventTarget().equals(orderInfo.getOrderStatus())) {
            return;
        }
        List deliverGoodVos = this.deliverGoodVoService.findByOrderCode(orderInfo.getOrderCode());
        boolean noneDeliver = (deliverGoodVos = deliverGoodVos.stream().filter(e -> !DeliverStatus.CANCEL.getType().equals(e.getDeliverStatus())).collect(Collectors.toList())).stream().noneMatch(e -> DeliverStatus.ALREADY_DELIVER.getType().equals(e.getDeliverStatus()));
        if (noneDeliver) {
            this.orderInfoService.nextOrderStatus(deliverGood.getOrderCode(), OrderStrategyEvent.Received);
        }
    }

    public void onRevoke(DeliverGood deliverGood) {
        OrderInfo orderInfo = this.validatePrefix(deliverGood);
        if (orderInfo == null || !OrderStrategyEvent.BeReceived.getEventTarget().equals(orderInfo.getOrderStatus()) && !OrderStrategyEvent.PartialShipped.getEventTarget().equals(orderInfo.getOrderStatus())) {
            return;
        }
        List deliverGoodVos = this.deliverGoodVoService.findByOrderCode(orderInfo.getOrderCode());
        deliverGoodVos = deliverGoodVos.stream().filter(e -> !DeliverStatus.CANCEL.getType().equals(e.getDeliverStatus())).collect(Collectors.toList());
        boolean allWait = deliverGoodVos.stream().allMatch(e -> DeliverStatus.WAIT_DELIVER.getType().equals(e.getDeliverStatus()));
        if (OrderStrategyEvent.BeReceived.getEventTarget().equals(orderInfo.getOrderStatus())) {
            if (allWait) {
                this.orderInfoService.nextOrderStatus(deliverGood.getOrderCode(), OrderStrategyEvent.BeShipped);
            } else {
                this.orderInfoService.nextOrderStatus(deliverGood.getOrderCode(), OrderStrategyEvent.PartialShipped);
            }
        } else if (OrderStrategyEvent.PartialShipped.getEventTarget().equals(orderInfo.getOrderStatus()) && allWait) {
            this.orderInfoService.nextOrderStatus(deliverGood.getOrderCode(), OrderStrategyEvent.BeShipped);
        }
    }

    public void onCancel(DeliverGood deliverGood) {
    }

    private OrderInfo validatePrefix(DeliverGood deliverGood) {
        String orderCode = deliverGood.getOrderCode();
        if (StringUtils.isBlank((CharSequence)orderCode)) {
            return null;
        }
        return this.orderInfoService.findByOrderCode(orderCode);
    }
}

