/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.notifier;

import com.bizunited.empower.business.order.entity.ReturnInfo;
import com.bizunited.empower.business.order.repository.ReturnInfoRepository;
import com.bizunited.empower.business.order.service.ReturnInfoService;
import com.bizunited.empower.business.order.service.ReturnStatusLoggerService;
import com.bizunited.empower.business.order.service.strategy.ReturnStrategyEvent;
import com.bizunited.empower.business.payment.entity.DefrayInfo;
import com.bizunited.empower.business.payment.entity.PaymentInfo;
import com.bizunited.empower.business.payment.service.notifier.PaymentEventListener;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="PaymentEventForReturnListenerImpl")
public class PaymentEventForReturnListenerImpl
implements PaymentEventListener {
    @Autowired
    private ReturnInfoRepository returnInfoRepository;
    @Autowired
    private ReturnInfoService returnInfoService;
    @Autowired
    private ReturnStatusLoggerService returnStatusLoggerService;

    @Transactional
    public void onDefray(PaymentInfo paymentInfo, DefrayInfo defrayInfo) {
        String returnCode = paymentInfo.getAssociatedCode();
        if (StringUtils.isBlank((CharSequence)returnCode) || StringUtils.indexOf((CharSequence)returnCode, (CharSequence)"TH") == -1) {
            return;
        }
        ReturnInfo currentReturnInfo = this.returnInfoService.findByReturnCode(returnCode);
        Validate.notNull((Object)((Object)currentReturnInfo), (String)"\u5f53\u6536\u5230\u4ed8\u6b3e\u901a\u77e5\u540e\uff0c\u672a\u53d1\u73b0\u5bf9\u5e94\u7684\u9000\u8d27\u5355\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.isTrue((paymentInfo.getPaymentStatus() != 1 ? 1 : 0) != 0, (String)"\u5f53\u6536\u5230\u4ed8\u6b3e\u901a\u77e5\u540e\uff0c\u53d1\u73b0\u4e86\u9519\u8bef\u7684\u4ed8\u6b3e\u51ed\u8bc1\u72b6\u6001\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        currentReturnInfo.setPaymentStatus(paymentInfo.getPaymentStatus());
        this.returnInfoRepository.save((Object)currentReturnInfo);
        if (paymentInfo.getPaymentStatus() == 3) {
            this.returnInfoService.nextReturnStatus(returnCode);
        }
        if (currentReturnInfo.getDeliveryStatus() == 1) {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            String opAccount = null;
            if (authentication != null) {
                opAccount = authentication.getName();
            }
            int currentStatus = paymentInfo.getPaymentStatus() == 3 ? 3 : 2;
            this.returnStatusLoggerService.create(currentReturnInfo.getId(), opAccount, 2, currentStatus);
        }
    }

    @Transactional
    public void onPaymentComplete(PaymentInfo paymentInfo) {
    }

    @Transactional
    public void onPaymentCancelled(PaymentInfo paymentInfo) {
        String returnCode = paymentInfo.getAssociatedCode();
        if (StringUtils.isBlank((CharSequence)returnCode)) {
            return;
        }
        ReturnInfo returnInfo = this.returnInfoService.findByReturnCode(returnCode);
        Validate.notNull((Object)((Object)returnInfo), (String)"\u672a\u53d1\u73b0\u4ed8\u6b3e\u51ed\u8bc1\u5bf9\u5e94\u7684\u9000\u8d27\u5355\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (returnInfo.getReturnStatus().intValue() == ReturnStrategyEvent.Cancelled.getEventTarget().intValue()) {
            return;
        }
        int returnStatus = returnInfo.getReturnStatus();
        int paymentStatus = returnInfo.getPaymentStatus();
        if (returnStatus == 1 && paymentStatus == 1) {
            return;
        }
        Validate.isTrue(((returnStatus == ReturnStrategyEvent.BeReviewed.getEventTarget() || returnStatus == ReturnStrategyEvent.BeReceived.getEventTarget()) && paymentStatus == 1 ? 1 : 0) != 0, (String)"\u5f53\u524d\u4ed8\u6b3e\u51ed\u8bc1\u5bf9\u5e94\u7684\u9000\u8d27\u5355\u4e0d\u5904\u4e8e\u201c\u5f85\u5ba1\u6838\u201d\u3001\u201c\u5f85\u9000\u8d27\u201d\u72b6\u6001\uff0c\u6216\u8005\u662f\u56e0\u4e3a\u4ed8\u6b3e\u51ed\u8bc1\u81f3\u5c11\u5df2\u7ecf\u652f\u4ed8\u4e86\u4e00\u90e8\u5206\u8d44\u91d1\uff0c\u6240\u4ee5\u8be5\u4ed8\u6b3e\u51ed\u8bc1\u4e0d\u5141\u8bb8\u4f5c\u5e9f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
    }
}

