/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.notifier;

import com.bizunited.empower.business.order.service.OrderProductService;
import com.bizunited.empower.business.product.entity.ProductSpecification;
import com.bizunited.empower.business.product.service.notifier.ProductSpecificationEventListener;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProductSpecificationForOrderListenerImpl
implements ProductSpecificationEventListener {
    @Autowired
    private OrderProductService orderProductService;

    public void onDelete(Set<ProductSpecification> productSpecifications) {
        Validate.notEmpty(productSpecifications, (String)"\u5546\u54c1\u89c4\u683c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Set<String> productSpecificationCodes = productSpecifications.stream().map(ProductSpecification::getProductSpecificationCode).collect(Collectors.toSet());
        boolean isExist = this.orderProductService.existBySpecificationCodes(productSpecificationCodes);
        Validate.isTrue((!isExist ? 1 : 0) != 0, (String)"\u8be5\u5546\u54c1\u5df2\u6709\u8ba2\u5355\u6b63\u5728\u4f7f\u7528\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664\u64cd\u4f5c", (Object[])new Object[0]);
    }

    public void onUpdate(Set<ProductSpecification> productSpecifications) {
        Validate.notEmpty(productSpecifications, (String)"\u5546\u54c1\u89c4\u683c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Map<String, String> productSpecificationMaps = productSpecifications.stream().collect(Collectors.toMap(ProductSpecification::getProductSpecificationCode, ProductSpecification::getProductSpecificationName));
        for (Map.Entry<String, String> entry : productSpecificationMaps.entrySet()) {
            boolean isSpecificationCodeExist = this.orderProductService.existBySpecificationCode(entry.getKey());
            if (!isSpecificationCodeExist) continue;
            boolean isExist = this.orderProductService.existBySpecificationCodeAndSpecificationName(entry.getKey(), entry.getValue());
            Validate.isTrue((boolean)isExist, (String)"\u8be5\u5546\u54c1\u5df2\u6709\u8ba2\u5355\u6b63\u5728\u4f7f\u7528\uff0c\u5546\u54c1\u89c4\u683c\u540d\u79f0\u4e0d\u80fd\u8fdb\u884c\u53d8\u52a8", (Object[])new Object[0]);
        }
    }
}

