/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.notifier;

import com.bizunited.empower.business.order.service.OrderProductService;
import com.bizunited.empower.business.product.entity.ProductUnit;
import com.bizunited.empower.business.product.entity.ProductUnitAndPrice;
import com.bizunited.empower.business.product.service.notifier.ProductUnitAndPriceEventListener;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProductUnitAndPriceForOrderListenerImpl
implements ProductUnitAndPriceEventListener {
    @Autowired
    private OrderProductService orderProductService;

    public void onDelete(Set<ProductUnitAndPrice> productUnitAndPrices) {
        Validate.notEmpty(productUnitAndPrices, (String)"\u5546\u54c1\u5355\u4f4d\u4e0e\u4ef7\u683c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        HashSet unitCodes = Sets.newHashSet();
        for (ProductUnitAndPrice productUnitAndPrice : productUnitAndPrices) {
            ProductUnit productUnit = productUnitAndPrice.getProductUnit();
            Validate.notNull((Object)productUnit, (String)"\u5546\u54c1\u5355\u4f4d\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            unitCodes.add(productUnit.getUnitCode());
        }
        boolean isExist = this.orderProductService.existByUnitCodes(unitCodes);
        Validate.isTrue((!isExist ? 1 : 0) != 0, (String)"\u8be5\u5546\u54c1\u5355\u4f4d\u5df2\u6709\u8ba2\u5355\u6b63\u5728\u4f7f\u7528\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664\u64cd\u4f5c", (Object[])new Object[0]);
    }

    public void onUpdate(Set<ProductUnitAndPrice> productUnitAndPrices) {
        Validate.notEmpty(productUnitAndPrices, (String)"\u5546\u54c1\u5355\u4f4d\u4e0e\u4ef7\u683c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        HashMap unitInfoMap = Maps.newHashMap();
        for (ProductUnitAndPrice productUnitAndPrice : productUnitAndPrices) {
            ProductUnit productUnit = productUnitAndPrice.getProductUnit();
            Validate.notNull((Object)productUnit, (String)"\u5546\u54c1\u5355\u4f4d\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            boolean isProductExistExist = this.orderProductService.existByUnitCode(productUnit.getUnitCode());
            if (!isProductExistExist) continue;
            boolean isExist = this.orderProductService.existByUnitCodeAndUnitName(productUnit.getUnitCode(), productUnit.getUnitName());
            Validate.isTrue((boolean)isExist, (String)"\u8be5\u5546\u54c1\u5df2\u6709\u8ba2\u5355\u6b63\u5728\u4f7f\u7528\uff0c\u5546\u54c1\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u8fdb\u884c\u53d8\u52a8", (Object[])new Object[0]);
        }
    }
}

