/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.notifier;

import com.bizunited.empower.business.order.entity.OrderInfo;
import com.bizunited.empower.business.order.repository.OrderInfoRepository;
import com.bizunited.empower.business.order.service.OrderInfoService;
import com.bizunited.empower.business.order.service.strategy.OrderStrategyEvent;
import com.bizunited.empower.business.payment.entity.ReceiptInfo;
import com.bizunited.empower.business.payment.entity.ReceivableInfo;
import com.bizunited.empower.business.payment.service.notifier.ReceivableEventListener;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="ReceivableEventForOrderListenerImpl")
public class ReceivableEventForOrderListenerImpl
implements ReceivableEventListener {
    @Autowired
    private OrderInfoRepository orderInfoRepository;
    @Autowired
    private OrderInfoService orderInfoService;

    @Transactional
    public void onReceipt(ReceivableInfo receivableInfo, ReceiptInfo receiptInfo) {
        String orderCode = receivableInfo.getAssociatedCode();
        String tenantCode = TenantUtils.getTenantCode();
        if (StringUtils.isBlank((CharSequence)orderCode) || StringUtils.indexOf((CharSequence)orderCode, (CharSequence)"DH") == -1) {
            return;
        }
        OrderInfo currentOrderInfo = this.orderInfoRepository.findByOrderCodeAndTenantCode(orderCode, tenantCode);
        Validate.notNull((Object)((Object)currentOrderInfo), (String)"\u5f53\u6536\u5230\u6536\u6b3e\u901a\u77e5\u540e\uff0c\u672a\u53d1\u73b0\u5bf9\u5e94\u7684\u8ba2\u5355\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.isTrue((receivableInfo.getReceivableStatus() != 1 ? 1 : 0) != 0, (String)"\u5f53\u6536\u5230\u6536\u6b3e\u901a\u77e5\u540e\uff0c\u53d1\u73b0\u4e86\u9519\u8bef\u7684\u6536\u6b3e\u5355\u72b6\u6001\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        currentOrderInfo.setReceivableStatus(receivableInfo.getReceivableStatus());
        this.orderInfoRepository.saveAndFlush((Object)currentOrderInfo);
        if (receivableInfo.getReceivableStatus() == 3) {
            this.orderInfoService.nextOrderStatus(orderCode);
        }
    }

    @Transactional
    public void onReceivableComplete(ReceivableInfo receivableInfo) {
    }

    @Transactional
    public void onReceivableCancelled(ReceivableInfo receivableInfo) {
        String orderCode = receivableInfo.getAssociatedCode();
        String tenantCode = TenantUtils.getTenantCode();
        if (StringUtils.isBlank((CharSequence)orderCode)) {
            return;
        }
        OrderInfo currentOrderInfo = this.orderInfoRepository.findByOrderCodeAndTenantCode(orderCode, tenantCode);
        Validate.notNull((Object)((Object)currentOrderInfo), (String)"\u5f53\u6536\u5230\u6536\u6b3e\u901a\u77e5\u540e\uff0c\u672a\u53d1\u73b0\u5bf9\u5e94\u7684\u8ba2\u5355\u4fe1\u606f!!", (Object[])new Object[0]);
        int receivableStatus = currentOrderInfo.getReceivableStatus();
        if (receivableStatus == 1) {
            return;
        }
        Validate.isTrue((currentOrderInfo.getOrderStatus().intValue() == OrderStrategyEvent.Cancelled.getEventTarget().intValue() ? 1 : 0) != 0, (String)"\u8ba2\u5355\u5e94\u6536\u51ed\u8bc1\u4e0d\u5141\u8bb8\u5355\u72ec\u53d6\u6d88\uff0c\u53ea\u80fd\u901a\u8fc7\u5173\u8054\u7684\u8ba2\u5355\u8fdb\u884c\u53d6\u6d88!!", (Object[])new Object[0]);
    }
}

