/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.notifier;

import com.bizunited.empower.business.order.entity.OrderInfo;
import com.bizunited.empower.business.order.repository.OrderInfoRepository;
import com.bizunited.empower.business.order.service.OrderInfoService;
import com.bizunited.empower.business.order.service.strategy.OrderStrategyEvent;
import com.bizunited.empower.business.vehicle.entity.VehicleUnload;
import com.bizunited.empower.business.vehicle.service.notify.VehicleUnloadListener;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VehicleUnloadEventForOrderListenerImpl
implements VehicleUnloadListener {
    @Autowired
    private OrderInfoRepository orderInfoRepository;
    @Autowired
    private OrderInfoService orderInfoService;

    public void onCompleted(VehicleUnload unloadOrder) {
        Validate.notNull((Object)unloadOrder, (String)"\u9519\u8bef\u7684\u5378\u8d27\u5355\u57fa\u672c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((unloadOrder.getVehicleUnloadStatus() == 2 ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u5378\u8d27\u5355\u72b6\u6001\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String relevanceCode = unloadOrder.getRelevanceCode();
        if (StringUtils.isBlank((CharSequence)relevanceCode)) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        OrderInfo currentOrderInfo = this.orderInfoRepository.findByOrderCodeAndTenantCode(relevanceCode, tenantCode);
        if (currentOrderInfo == null) {
            return;
        }
        currentOrderInfo.setDeliveryStatus(3);
        this.orderInfoRepository.saveAndFlush((Object)currentOrderInfo);
        this.orderInfoService.nextOrderStatus(currentOrderInfo.getOrderCode(), OrderStrategyEvent.Received);
    }
}

