/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.notifier;

import com.bizunited.empower.business.order.entity.OrderInfo;
import com.bizunited.empower.business.order.entity.OrderProduct;
import com.bizunited.empower.business.order.entity.ReturnInfo;
import com.bizunited.empower.business.order.repository.ReturnInfoRepository;
import com.bizunited.empower.business.order.service.ReturnInfoService;
import com.bizunited.empower.business.warehouse.entity.WarehouseProductsEnter;
import com.bizunited.empower.business.warehouse.entity.WarehouseProductsEnterProduct;
import com.bizunited.empower.business.warehouse.service.WarehouseProductsEnterService;
import com.bizunited.empower.business.warehouse.service.notifier.WarehouseEnterEventListener;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="WarehouseEnterEventForOrderListenerImpl")
public class WarehouseEnterEventForOrderListenerImpl
implements WarehouseEnterEventListener {
    @Autowired
    private ReturnInfoRepository returnInfoRepository;
    @Autowired
    private ReturnInfoService returnInfoService;
    @Autowired
    private WarehouseProductsEnterService warehouseProductsEnterService;

    @Transactional
    public void onCompleted(WarehouseProductsEnter warehouseProductsEnter) {
        if (warehouseProductsEnter.getType() != 2) {
            return;
        }
        String relevanceCode = warehouseProductsEnter.getRelevanceCode();
        Validate.notBlank((CharSequence)relevanceCode, (String)"\u5728\u5b8c\u6210\u5165\u5e93\u5355\u4e1a\u52a1\u65f6\uff0c\u672a\u53d1\u73b0\u5165\u5e93\u5355\u5bf9\u5e94\u7684\u9000\u8d27\u5355\u4e1a\u52a1\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        ReturnInfo returnInfo = this.returnInfoService.findByReturnCode(relevanceCode);
        Validate.notNull((Object)((Object)returnInfo), (String)"\u672a\u53d1\u73b0\u7f16\u53f7\u4e3a\u3010%s\u3011\u7684\u9000\u8d27\u5355\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{relevanceCode});
        returnInfo.setDeliveryStatus(2);
        returnInfo.setReturnTime(new Date());
        this.returnInfoRepository.saveAndFlush((Object)returnInfo);
        this.returnInfoService.nextReturnStatus(relevanceCode);
    }

    @Transactional
    public void onCancelled(WarehouseProductsEnter warehouseProductsEnter) {
    }

    @Transactional
    public void onCreated(WarehouseProductsEnter warehouseProductsEnter) {
        String returnInfoCode = warehouseProductsEnter.getRelevanceCode();
        Integer warehouseEnterType = warehouseProductsEnter.getType();
        if (warehouseEnterType != 2 || StringUtils.isBlank((CharSequence)returnInfoCode)) {
            return;
        }
        ReturnInfo returnInfo = this.returnInfoService.findByReturnCode(returnInfoCode);
        Validate.notNull((Object)((Object)returnInfo), (String)"\u672a\u53d1\u73b0\u7f16\u53f7\u4e3a\u3010%s\u3011\u7684\u9000\u8d27\u5355\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{returnInfoCode});
        int deliveryStatus = returnInfo.getDeliveryStatus();
        Validate.isTrue((deliveryStatus == 1 ? 1 : 0) != 0, (String)"\u5165\u5e93\uff08\u9500\u552e\u9000\u8d27\uff09\u5355\u521b\u5efa\u65f6\uff0c\u53d1\u73b0\u5176\u5173\u8054\u7684\u9000\u8d27\u5355\u5df2\u7ecf\u5b8c\u6210\u914d\u9001\uff0c\u4e0d\u5141\u8bb8\u518d\u8fdb\u884c\u5173\u8054\u521b\u5efa!!", (Object[])new Object[0]);
        OrderInfo orderInfo = returnInfo.getOrderInfo();
        if (orderInfo == null) {
            return;
        }
        String orderCode = orderInfo.getOrderCode();
        Set<OrderProduct> orderProducts = orderInfo.getOrderProducts();
        Validate.notNull((Object)((Object)orderInfo), (String)"\u9000\u8d27\u5355\u5173\u8054\u4e86\u9519\u8bef\u7684\u8ba2\u5355\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(orderProducts) ? 1 : 0) != 0, (String)"\u9000\u8d27\u5355\u5173\u8054\u4e86\u9519\u8bef\u7684\u8ba2\u5355\uff08\u660e\u7ec6\uff09\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set<ReturnInfo> returnInfos = this.returnInfoRepository.findByOrderId(orderInfo.getId());
        if (CollectionUtils.isEmpty(returnInfos)) {
            return;
        }
        List returnInfoCodes = returnInfos.stream().map(ReturnInfo::getReturnCode).collect(Collectors.toList());
        List warehouseProductsEnters = this.warehouseProductsEnterService.findPreemptByRelevanceCodes(returnInfoCodes);
        if (CollectionUtils.isEmpty((Collection)warehouseProductsEnters)) {
            return;
        }
        HashMap sourceTotalMapping = Maps.newHashMap();
        for (OrderProduct orderProductItem : orderProducts) {
            String string = orderProductItem.getId();
            BigDecimal orderQuantity = orderProductItem.getOrderQuantity();
            if (orderQuantity == null) {
                orderQuantity = BigDecimal.ZERO;
            }
            if (sourceTotalMapping.get(string) == null) {
                sourceTotalMapping.put(string, orderQuantity);
                continue;
            }
            sourceTotalMapping.put(string, orderQuantity.add((BigDecimal)sourceTotalMapping.get(string)));
        }
        HashMap targetTotalMapping = Maps.newHashMap();
        for (WarehouseProductsEnter warehouseProductsEnter2 : warehouseProductsEnters) {
            Set enterProducts = warehouseProductsEnter2.getProducts();
            if (enterProducts == null) continue;
            for (WarehouseProductsEnterProduct enterProductItem : enterProducts) {
                String orderRelevanceDetailCode = enterProductItem.getRelevanceDetailCode();
                BigDecimal enterQuantity = enterProductItem.getQuantity();
                if (enterQuantity == null) {
                    enterQuantity = BigDecimal.ZERO;
                }
                if (targetTotalMapping.get(orderRelevanceDetailCode) == null) {
                    targetTotalMapping.put(orderRelevanceDetailCode, enterQuantity);
                    continue;
                }
                targetTotalMapping.put(orderRelevanceDetailCode, enterQuantity.add((BigDecimal)targetTotalMapping.get(orderRelevanceDetailCode)));
            }
        }
        for (Map.Entry entry : targetTotalMapping.entrySet()) {
            BigDecimal sourceQuantity;
            String productSpecificationCode = (String)entry.getKey();
            BigDecimal targetQuantity = (BigDecimal)entry.getValue();
            if (targetQuantity == null || (sourceQuantity = (BigDecimal)sourceTotalMapping.get(productSpecificationCode)) == null) continue;
            Validate.isTrue((targetQuantity.floatValue() <= sourceQuantity.floatValue() ? 1 : 0) != 0, (String)"\u9519\u8bef\uff1a\u5728\u672c\u6b21\u5165\u5e93\u5355\u521b\u5efa\u540e\uff0c\u7f16\u53f7[%s]\u7684\u5546\u54c1\u89c4\u683c\u5165\u5e93\u603b\u6570\uff0c\u5c06\u8d85\u8fc7\u8ba2\u5355[%s]\u4e2d\u8be5\u5546\u54c1\u89c4\u683c\u7684\u603b\u8ba2\u8d2d\u6570\u91cf\uff08\u53ef\u80fd\u662f\u5546\u54c1\u4e5f\u53ef\u80fd\u662f\u8d60\u54c1\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{productSpecificationCode, orderCode});
        }
    }
}

