/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.notifier;

import com.bizunited.empower.business.customer.entity.Customer;
import com.bizunited.empower.business.customer.service.CustomerService;
import com.bizunited.empower.business.distribution.service.DeliverGoodVoService;
import com.bizunited.empower.business.order.entity.OrderInfo;
import com.bizunited.empower.business.order.entity.OrderLogisticsInfo;
import com.bizunited.empower.business.order.entity.OrderProduct;
import com.bizunited.empower.business.order.entity.ReturnInfo;
import com.bizunited.empower.business.order.entity.ReturnProduct;
import com.bizunited.empower.business.order.repository.OrderInfoRepository;
import com.bizunited.empower.business.order.service.OrderInfoService;
import com.bizunited.empower.business.order.service.ReturnInfoService;
import com.bizunited.empower.business.order.service.analysis.WarehouseExpenseAnalysis;
import com.bizunited.empower.business.order.service.strategy.OrderStrategyEvent;
import com.bizunited.empower.business.product.dto.BrandAndUnitMapBarCodeDto;
import com.bizunited.empower.business.product.service.ProductSpecificationVoService;
import com.bizunited.empower.business.tenant.utils.DealerTenantUtils;
import com.bizunited.empower.business.warehouse.common.enums.WarehouseProductsExpenseState;
import com.bizunited.empower.business.warehouse.dto.AuthorizeDto;
import com.bizunited.empower.business.warehouse.dto.AuthorizeProductsDto;
import com.bizunited.empower.business.warehouse.entity.WarehouseInfo;
import com.bizunited.empower.business.warehouse.entity.WarehouseProductsExpense;
import com.bizunited.empower.business.warehouse.entity.WarehouseProductsExpenseProduct;
import com.bizunited.empower.business.warehouse.service.WarehouseActionService;
import com.bizunited.empower.business.warehouse.service.WarehouseInfoService;
import com.bizunited.empower.business.warehouse.service.WarehouseProductsExpenseService;
import com.bizunited.empower.business.warehouse.service.notifier.WarehouseExpenseEventListener;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="WarehouseExpenseCompletedEventForOrderListener")
public class WarehouseExpenseEventForOrderListenerImpl
implements WarehouseExpenseEventListener {
    @Autowired
    private OrderInfoRepository orderInfoRepository;
    @Autowired
    private OrderInfoService orderInfoService;
    @Autowired
    private ReturnInfoService returnInfoService;
    @Autowired
    private ProductSpecificationVoService productSpecificationVoService;
    @Autowired
    private WarehouseProductsExpenseService warehouseProductsExpenseService;
    @Autowired
    private WarehouseExpenseAnalysis warehouseExpenseAnalysis;
    @Autowired
    private DeliverGoodVoService deliverGoodVoService;
    @Autowired
    private CustomerService customerService;
    @Autowired
    private WarehouseInfoService warehouseInfoService;
    @Autowired
    private WarehouseActionService warehouseActionService;

    @Transactional
    public void onTransport(WarehouseProductsExpense warehouseProductsExpense) {
    }

    @Transactional
    public void onCompleted(WarehouseProductsExpense warehouseProductsExpense) {
        if (warehouseProductsExpense.getType() != 1) {
            return;
        }
        boolean isAllDone = this.warehouseExpenseAnalysis.validateAllDone(null, warehouseProductsExpense);
        if (!isAllDone) {
            this.orderInfoService.nextOrderStatus(warehouseProductsExpense.getRelevanceCode(), OrderStrategyEvent.PartialDelivered);
            return;
        }
        this.orderInfoService.nextOrderStatus(warehouseProductsExpense.getRelevanceCode(), OrderStrategyEvent.BeShipped);
    }

    @Transactional
    public void onCancelled(WarehouseProductsExpense warehouseProductsExpense) {
        if (warehouseProductsExpense.getType() != 1) {
            return;
        }
        String relevanceCode = warehouseProductsExpense.getRelevanceCode();
        Validate.notBlank((CharSequence)relevanceCode, (String)"\u5f02\u5e38\u7684\u51fa\u5e93\u5355\u4e0e\u8ba2\u5355\u5173\u8054\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Object[])new Object[0]);
        OrderInfo orderInfo = this.orderInfoService.findByOrderCode(relevanceCode);
        Validate.notNull((Object)((Object)orderInfo), (String)"\u5f02\u5e38\u7684\u51fa\u5e93\u5355\u4e0e\u8ba2\u5355\u5173\u8054\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Object[])new Object[0]);
        Validate.isTrue((OrderStrategyEvent.PartialDelivered.getEventTarget().equals(orderInfo.getOrderStatus()) || OrderStrategyEvent.BeShipped.getEventTarget().equals(orderInfo.getOrderStatus()) ? 1 : 0) != 0, (String)"\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u4e0d\u662f\u3010\u90e8\u5206\u51fa\u5e93\u3011\u6216\u3010\u5f85\u53d1\u8d27\u3011\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u51fa\u5e93\u53d6\u6d88\u64cd\u4f5c", (Object[])new Object[0]);
        List expenses = this.warehouseProductsExpenseService.findByRelevanceCode(relevanceCode);
        Validate.notEmpty((Collection)expenses, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5173\u51fa\u5e93\u5355\u4fe1\u606f", (Object[])new Object[0]);
        List expenseProducts = warehouseProductsExpense.getExpenseProducts();
        Customer customer = this.customerService.findByTenantCodeAndCustomerCode(TenantUtils.getTenantCode(), orderInfo.getCustomerCode());
        Validate.notNull((Object)customer, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u5ba2\u6237\u7f16\u7801\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u5ba2\u6237\u4fe1\u606f", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)customer.getWarehouseCode(), (String)"\u5ba2\u6237\u7684\u53d1\u8d27\u4ed3\u5e93\u4fe1\u606f\u672a\u914d\u7f6e", (Object[])new Object[0]);
        WarehouseInfo warehouseInfo = this.warehouseInfoService.findByWarehouseCode(customer.getWarehouseCode());
        Validate.notNull((Object)warehouseInfo, (String)"\u9884\u5360\u5e93\u5b58\u65f6\uff0c\u53d1\u73b0\u6ca1\u6709\u53ef\u7528\u7684\u4ed3\u5e93\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Object[])new Object[0]);
        Boolean overflowWarehouseStatus = DealerTenantUtils.getOverflowWarehouseStatus();
        for (WarehouseProductsExpenseProduct expenseProduct : expenseProducts) {
            BigDecimal quantity = this.warehouseActionService.conversionUnit(expenseProduct.getProductSpecificationCode(), expenseProduct.getUnitCode(), expenseProduct.getQuantity());
            this.warehouseActionService.preemption(expenseProduct.getProductSpecificationCode(), customer.getWarehouseCode(), quantity, overflowWarehouseStatus.booleanValue());
        }
        expenses = expenses.stream().filter(e -> !e.getState().equals(WarehouseProductsExpenseState.CANCELLED.getState())).collect(Collectors.toList());
        boolean hasDoneExpense = expenses.stream().anyMatch(e -> e.getState().equals(WarehouseProductsExpenseState.COMPLETED.getState()));
        if (OrderStrategyEvent.PartialDelivered.getEventTarget().equals(orderInfo.getOrderStatus())) {
            if (!hasDoneExpense) {
                this.orderInfoService.nextOrderStatusById(orderInfo.getId(), OrderStrategyEvent.BeDelivered);
            }
        } else if (OrderStrategyEvent.BeShipped.getEventTarget().equals(orderInfo.getOrderStatus())) {
            if (hasDoneExpense) {
                this.orderInfoService.nextOrderStatusById(orderInfo.getId(), OrderStrategyEvent.PartialDelivered);
            } else {
                this.orderInfoService.nextOrderStatusById(orderInfo.getId(), OrderStrategyEvent.BeDelivered);
            }
        }
    }

    public void onCreated(WarehouseProductsExpense warehouseProductsExpense) {
        if (warehouseProductsExpense.getType() != 1) {
            return;
        }
        HashMap<String, BigDecimal> productSpecificationMapping = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> productOrderMapping = new HashMap<String, BigDecimal>();
        this.warehouseExpenseAnalysis.analysisWarehouseProductsExpense(null, warehouseProductsExpense, productSpecificationMapping, productOrderMapping);
        OrderInfo orderInfo = this.orderInfoService.findByOrderCode(warehouseProductsExpense.getRelevanceCode());
        Set<OrderProduct> orderProducts = orderInfo.getOrderProducts();
        for (OrderProduct orderProductItem : orderProducts) {
            String productSpecificationCode = orderProductItem.getProductSpecificationCode();
            String orderProductId = orderProductItem.getId();
            BigDecimal orderQuantity = orderProductItem.getOrderQuantity();
            BigDecimal expenseQuantity = productOrderMapping.get(orderProductId) == null ? BigDecimal.valueOf(0L) : (BigDecimal)productOrderMapping.get(orderProductId);
            Validate.isTrue((orderQuantity.floatValue() >= expenseQuantity.floatValue() ? 1 : 0) != 0, (String)"\u7f16\u53f7\u3010%s\u3011\u7684\u5546\u54c1\u89c4\u683c\uff0c\u5728\u672c\u6b21\u6b63\u5f0f\u51fa\u5e93\u540e\uff0c\u8ba2\u5355\u660e\u7ec6\u5c06\u4f1a\u8d85\u51fa\uff08\u8d85\u5356\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{productSpecificationCode});
        }
    }

    @Transactional
    public void onAuthorize(AuthorizeDto authorizeDto) {
        String tenantCode = TenantUtils.getTenantCode();
        String orderCode = authorizeDto.getRelevanceCode();
        OrderInfo cOrderInfo = this.orderInfoRepository.findByOrderCodeAndTenantCode(orderCode, tenantCode);
        if (cOrderInfo == null || cOrderInfo.getOrderType() != 2) {
            return;
        }
        Validate.isTrue((boolean)OrderStrategyEvent.Completed.getEventTarget().equals(cOrderInfo.getOrderStatus()), (String)"\u51fa\u5e93\u5355\u6838\u51c6\u64cd\u4f5c\u65f6\uff0c\u76f8\u5173\u8ba2\u5355\u53ea\u80fd\u662f\u3010\u5df2\u5b8c\u6210\u3011\u72b6\u6001!", (Object[])new Object[0]);
        Set authorizeProducts = authorizeDto.getProducts();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)authorizeProducts) ? 1 : 0) != 0, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u6838\u51c6\u660e\u7ec6\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set<OrderLogisticsInfo> orderLogistics = cOrderInfo.getLogisticsInfo();
        Validate.isTrue((!CollectionUtils.isEmpty(orderLogistics) ? 1 : 0) != 0, (String)"\u51fa\u5e93\u5355\u6838\u51c6\u64cd\u4f5c\u65f6\uff0c\u672a\u53d1\u73b0\u539f\u59cb\u8ba2\u5355\u4e0a\u7684\u7269\u6d41\u914d\u9001\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6838\u51c6\u64cd\u4f5c!!", (Object[])new Object[0]);
        OrderLogisticsInfo orderLogistic = orderLogistics.iterator().next();
        String address = orderLogistic.getAddress();
        String contactPerson = orderLogistic.getContactPerson();
        String phone = orderLogistic.getPhone();
        ReturnInfo returnInfo = new ReturnInfo();
        returnInfo.setDeliveryStatus(1);
        returnInfo.setPaymentStatus(1);
        returnInfo.setRelationOrder(true);
        returnInfo.setOrderInfo(cOrderInfo);
        returnInfo.setAddress(address);
        returnInfo.setContactPerson(contactPerson);
        returnInfo.setCustomerCode(cOrderInfo.getCustomerCode());
        returnInfo.setPhone(phone);
        returnInfo.setReturnSource("\u6838\u51c6\u9000\u8d27");
        returnInfo.setRemark(String.format("\u8ba2\u5355[%s]\u76f8\u5173\u51fa\u5e93\u5355\uff0c\u6838\u51c6\u7684\u9000\u8d27\u5355", orderCode));
        returnInfo.setReturnTime(new Date());
        returnInfo.setFare(authorizeDto.getFare());
        returnInfo.setReturnSpecialPrice(BigDecimal.ZERO);
        returnInfo.setProductTotalPrice(authorizeDto.getTotalPrice());
        BigDecimal returnTotalPrice = authorizeDto.getTotalPrice().add(authorizeDto.getFare()).setScale(2, RoundingMode.UP);
        returnInfo.setReturnTotalPrice(returnTotalPrice);
        List productSpecificationCodes = authorizeProducts.stream().map(AuthorizeProductsDto::getProductSpecificationCode).distinct().collect(Collectors.toList());
        BrandAndUnitMapBarCodeDto brandAndUnitMapBarCodeMapping = this.productSpecificationVoService.findBrandAndUnitMapBarCodeBySpecCodes(productSpecificationCodes);
        HashSet returnProducts = Sets.newHashSet();
        for (AuthorizeProductsDto authorizeProduct : authorizeProducts) {
            String unitCode = authorizeProduct.getUnitCode();
            String productSpecificationCode = authorizeProduct.getProductSpecificationCode();
            BrandAndUnitMapBarCodeDto brandAndUnitMapBarCode = brandAndUnitMapBarCodeMapping.getBrandAndUnitMapBarCodeDto(productSpecificationCode, unitCode);
            Validate.notNull((Object)brandAndUnitMapBarCode, (String)"\u6838\u51c6\u64cd\u4f5c\u65f6\uff0c\u53d1\u73b0\u672a\u5339\u914d\u7684\u5546\u54c1\u89c4\u683c\u4fe1\u606f", (Object[])new Object[0]);
            ReturnProduct returnProduct = new ReturnProduct();
            returnProduct.setGift(authorizeProduct.getGift());
            returnProduct.setInternationalBarcode(brandAndUnitMapBarCode.getBarCode());
            returnProduct.setUnitCode(unitCode);
            returnProduct.setProductSpecificationCode(brandAndUnitMapBarCode.getProductSpecificationCode());
            returnProduct.setProductSpecificationName(brandAndUnitMapBarCode.getProductSpecificationName());
            returnProduct.setRemark("\u6838\u51c6\u9000\u8d27\u660e\u7ec6");
            returnProduct.setReturnInfo(returnInfo);
            returnProduct.setUnitPrice(authorizeProduct.getPrice());
            returnProduct.setReturnQuantity(authorizeProduct.getQuantity());
            BigDecimal subtotalAmount = authorizeProduct.getPrice().multiply(authorizeProduct.getQuantity()).setScale(4, RoundingMode.HALF_UP);
            returnProduct.setSubtotalAmount(subtotalAmount);
            returnProducts.add(returnProduct);
        }
        returnInfo.setReturnProducts(returnProducts);
        this.returnInfoService.create(returnInfo, false);
    }
}

