/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.strategy;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public enum OrderStrategyEvent {
    BeAudit("to_be_audit", 1),
    BeDelivered("to_be_delivered", 2),
    PartialDelivered("partial_delivered", 3),
    BeShipped("to_be_shipped", 4),
    PartialShipped("partial_shipped", 5),
    BeReceived("to_be_received", 6),
    Received("received", 7),
    BeCancel("to_be_cancel", 100),
    Cancelled("cancelled", 200),
    Completed("completed", 999);

    private static final Map<String, OrderStrategyEvent> EVENT_MAP;
    private String eventName;
    private Integer eventTarget;

    private OrderStrategyEvent(String eventName, Integer eventTarget) {
        this.eventName = eventName;
        this.eventTarget = eventTarget;
    }

    public static OrderStrategyEvent getByEventValue(Integer value) {
        Collection<OrderStrategyEvent> events = EVENT_MAP.values();
        for (OrderStrategyEvent orderStrategyEvent : events) {
            if (orderStrategyEvent.eventTarget.intValue() != value.intValue()) continue;
            return orderStrategyEvent;
        }
        return null;
    }

    public String getEventName() {
        return this.eventName;
    }

    public Integer getEventTarget() {
        return this.eventTarget;
    }

    static {
        EVENT_MAP = new HashMap<String, OrderStrategyEvent>();
        for (OrderStrategyEvent event : OrderStrategyEvent.values()) {
            EVENT_MAP.put(event.eventName, event);
        }
    }
}

