/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.strategy;

import com.alibaba.fastjson.JSONArray;
import com.bizunited.empower.business.customer.entity.Customer;
import com.bizunited.empower.business.customer.service.CustomerService;
import com.bizunited.empower.business.order.entity.OrderAuditSetting;
import com.bizunited.empower.business.order.entity.OrderInfo;
import com.bizunited.empower.business.order.entity.OrderProduct;
import com.bizunited.empower.business.order.repository.OrderInfoRepository;
import com.bizunited.empower.business.order.service.OrderAuditSettingService;
import com.bizunited.empower.business.order.service.notifier.OrderCreatedEventListener;
import com.bizunited.empower.business.order.service.strategy.OrderAbstractLoggedAbleStrategy;
import com.bizunited.empower.business.order.service.strategy.OrderRoamStrategy;
import com.bizunited.empower.business.order.service.strategy.OrderStrategyEvent;
import com.bizunited.empower.business.payment.common.enums.ReceivableType;
import com.bizunited.empower.business.payment.service.ReceivableInfoService;
import com.bizunited.empower.business.policy.service.RebateAccountBrandDetailsService;
import com.bizunited.empower.business.policy.service.RebateAccountCommonDetailsService;
import com.bizunited.empower.business.policy.service.RebateAccountProductDetailsService;
import com.bizunited.empower.business.policy.service.SalePolicyResultService;
import com.bizunited.empower.business.tenant.utils.DealerTenantUtils;
import com.bizunited.empower.business.warehouse.entity.WarehouseInfo;
import com.bizunited.empower.business.warehouse.service.WarehouseActionService;
import com.bizunited.empower.business.warehouse.service.WarehouseInfoService;
import com.bizunited.platform.common.service.redis.RedisMutexService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="OrderToBeAuditRoamStrategy")
public class OrderToBeAuditRoamStrategy
extends OrderAbstractLoggedAbleStrategy
implements OrderRoamStrategy {
    private static final String ORDER_CODE_PREFIX = "DH";
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private ReceivableInfoService receivableInfoService;
    @Autowired
    private SalePolicyResultService salePolicyResultService;
    @Autowired
    private RebateAccountBrandDetailsService rebateAccountBrandDetailsService;
    @Autowired
    private RebateAccountCommonDetailsService rebateAccountCommonDetailsService;
    @Autowired
    private RebateAccountProductDetailsService rebateAccountProductDetailsService;
    @Autowired(required=false)
    private List<OrderCreatedEventListener> orderCreatedEventListeners;
    @Autowired
    private OrderAuditSettingService orderAuditSettingService;
    @Autowired
    private WarehouseActionService warehouseActionService;
    @Autowired
    private WarehouseInfoService warehouseInfoService;
    @Autowired
    private OrderInfoRepository orderInfoRepository;
    @Autowired
    private CustomerService customerService;

    @Override
    public OrderStrategyEvent manualValidate() {
        return OrderStrategyEvent.BeAudit;
    }

    @Override
    public Boolean automaticValidate(OrderInfo orderInfo) {
        Integer previousOrderStatus = orderInfo.getOrderStatus();
        return previousOrderStatus == null;
    }

    @Override
    @Transactional
    public void action(OrderInfo orderInfo) {
        Integer previousOrderStatus = orderInfo.getOrderStatus();
        if (previousOrderStatus == null) {
            this.actionForward(orderInfo);
            return;
        }
        if (orderInfo.getOrderStatus().equals(OrderStrategyEvent.BeDelivered.getEventTarget())) {
            this.actionReverse(orderInfo);
        }
    }

    private void actionForward(OrderInfo orderInfo) {
        Date now = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        String datecode = dateFormat.format(now);
        if (orderInfo.getOrderType() == 2) {
            orderInfo.setOrderStatus(OrderStrategyEvent.BeReceived.getEventTarget());
            orderInfo.setDeliveryStatus(2);
        } else {
            orderInfo.setOrderStatus(1);
        }
        orderInfo.setReceivableStatus(1);
        String oldOrderCode = orderInfo.getOrderCode();
        String tenantCode = TenantUtils.getTenantCode();
        String codeUnKey = StringUtils.join((Object[])new String[]{ORDER_CODE_PREFIX, "_", tenantCode});
        String atomicNumberValue = this.redisMutexService.getAndIncrement(codeUnKey, 1L, Integer.valueOf(6), 25L, TimeUnit.HOURS);
        String orderCode = StringUtils.join((Object[])new String[]{ORDER_CODE_PREFIX, datecode, atomicNumberValue});
        orderInfo.setOrderCode(orderCode);
        this.orderInfoRepository.saveAndFlush((Object)orderInfo);
        if (orderInfo.getOrderType() != 2) {
            Customer customer = this.customerService.findByTenantCodeAndCustomerCode(tenantCode, orderInfo.getCustomerCode());
            Validate.notNull((Object)customer, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u5ba2\u6237\u7f16\u7801\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u5ba2\u6237\u4fe1\u606f", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)customer.getWarehouseCode(), (String)"\u5ba2\u6237\u7684\u53d1\u8d27\u4ed3\u5e93\u4fe1\u606f\u672a\u914d\u7f6e", (Object[])new Object[0]);
            WarehouseInfo warehouseInfo = this.warehouseInfoService.findByWarehouseCode(customer.getWarehouseCode());
            Validate.notNull((Object)warehouseInfo, (String)"\u9884\u5360\u5e93\u5b58\u65f6\uff0c\u53d1\u73b0\u6ca1\u6709\u53ef\u7528\u7684\u4ed3\u5e93\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Object[])new Object[0]);
            Boolean overflowWarehouseStatus = DealerTenantUtils.getOverflowWarehouseStatus();
            for (OrderProduct orderProduct : orderInfo.getOrderProducts()) {
                BigDecimal quantity = this.warehouseActionService.conversionUnit(orderProduct.getProductSpecificationCode(), orderProduct.getUnitCode(), orderProduct.getOrderQuantity());
                this.warehouseActionService.preemption(orderProduct.getProductSpecificationCode(), customer.getWarehouseCode(), quantity, overflowWarehouseStatus.booleanValue());
            }
        }
        this.salePolicyResultService.updateRelevanceCode(oldOrderCode, orderCode);
        this.rebateAccountCommonDetailsService.updateRelevanceCode(oldOrderCode, orderCode);
        this.rebateAccountBrandDetailsService.updateRelevanceCode(oldOrderCode, orderCode);
        this.rebateAccountProductDetailsService.updateRelevanceCode(oldOrderCode, orderCode);
        this.orderInfoRepository.flush();
        this.receivableInfoService.createByAssociatedCode(orderInfo.getCustomerCode(), orderCode, orderInfo.getOrderTotalPrice(), ReceivableType.ORDER);
        if (!CollectionUtils.isEmpty(this.orderCreatedEventListeners)) {
            this.orderCreatedEventListeners.forEach(item -> item.onOrderCreated(orderInfo));
        }
        super.logged(orderInfo.getId(), null, orderInfo.getOrderStatus());
    }

    private void actionReverse(OrderInfo orderInfo) {
        this.processOrderAuditInfo(orderInfo);
        orderInfo.setOrderStatus(OrderStrategyEvent.BeAudit.getEventTarget());
        this.orderInfoRepository.saveAndFlush((Object)orderInfo);
        super.logged(orderInfo.getId(), OrderStrategyEvent.BeDelivered.getEventTarget(), orderInfo.getOrderStatus());
    }

    private void processOrderAuditInfo(OrderInfo orderInfo) {
        OrderAuditSetting setting = this.orderAuditSettingService.findByOrderId(orderInfo.getId());
        JSONArray currentOrderAuditSettingArray = DealerTenantUtils.getAuditNodeSettings();
        if (setting == null) {
            setting = new OrderAuditSetting();
            setting.setOrderInfo(orderInfo);
            setting.setAuditNodeSettings(currentOrderAuditSettingArray.toJSONString());
            setting.setAuditVersion(this.orderAuditSettingService.generateAuditVersion(null));
            this.orderAuditSettingService.create(setting);
        } else {
            setting.setOrderInfo(orderInfo);
            setting.setAuditNodeSettings(currentOrderAuditSettingArray.toJSONString());
            setting.setAuditVersion(this.orderAuditSettingService.generateAuditVersion(setting.getAuditVersion()));
            this.orderAuditSettingService.update(setting);
        }
    }
}

