/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.strategy;

import com.bizunited.empower.business.customer.entity.Customer;
import com.bizunited.empower.business.customer.service.CustomerService;
import com.bizunited.empower.business.order.entity.OrderInfo;
import com.bizunited.empower.business.order.entity.OrderProduct;
import com.bizunited.empower.business.order.repository.OrderInfoRepository;
import com.bizunited.empower.business.order.service.strategy.OrderAbstractLoggedAbleStrategy;
import com.bizunited.empower.business.order.service.strategy.OrderRoamStrategy;
import com.bizunited.empower.business.order.service.strategy.OrderStrategyEvent;
import com.bizunited.empower.business.warehouse.entity.WarehouseInfo;
import com.bizunited.empower.business.warehouse.service.WarehouseActionService;
import com.bizunited.empower.business.warehouse.service.WarehouseInfoService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="OrderToBeCancelRoamStrategy")
public class OrderToBeCancelRoamStrategy
extends OrderAbstractLoggedAbleStrategy
implements OrderRoamStrategy {
    @Autowired
    private OrderInfoRepository orderInfoRepository;
    @Autowired
    private WarehouseActionService warehouseActionService;
    @Autowired
    private WarehouseInfoService warehouseInfoService;
    @Autowired
    private CustomerService customerService;

    @Override
    public OrderStrategyEvent manualValidate() {
        return OrderStrategyEvent.BeCancel;
    }

    @Override
    public Boolean automaticValidate(OrderInfo orderInfo) {
        return false;
    }

    @Override
    @Transactional
    public void action(OrderInfo orderInfo) {
        Integer previouStatus = orderInfo.getOrderStatus();
        if (orderInfo.getOrderType() != 2) {
            Validate.isTrue((previouStatus.equals(OrderStrategyEvent.BeAudit.getEventTarget()) || previouStatus.equals(OrderStrategyEvent.BeDelivered.getEventTarget()) ? 1 : 0) != 0, (String)"\u76ee\u524d\u4ec5\u652f\u6301\u3010\u5f85\u5ba1\u6838\u3011\u3010\u5f85\u51fa\u5e93\u3011\u72b6\u6001\u7684\u53d6\u6d88\u8ba2\u5355\u64cd\u4f5c", (Object[])new Object[0]);
            Customer customer = this.customerService.findByTenantCodeAndCustomerCode(TenantUtils.getTenantCode(), orderInfo.getCustomerCode());
            Validate.notNull((Object)customer, (String)"\u53d6\u6d88\u8ba2\u5355\u65f6\uff0c\u8ba2\u5355\u7684\u5ba2\u6237\u4fe1\u606f\u672a\u80fd\u83b7\u53d6\u5230\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            String warehouseCode = customer.getWarehouseCode();
            if (StringUtils.isBlank((CharSequence)warehouseCode)) {
                WarehouseInfo warehouseInfo = this.warehouseInfoService.findVirtualWarehouse();
                Validate.notNull((Object)warehouseInfo, (String)"\u8ba2\u5355\u53d6\u6d88\u65f6\uff0c\u6ca1\u6709\u53d1\u73b0\u53ef\u7528\u7684\u4ed3\u5e93\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Object[])new Object[0]);
                warehouseCode = warehouseInfo.getWarehouseCode();
            }
            for (OrderProduct orderProduct : orderInfo.getOrderProducts()) {
                BigDecimal quantity = this.warehouseActionService.conversionUnit(orderProduct.getProductSpecificationCode(), orderProduct.getUnitCode(), orderProduct.getOrderQuantity());
                this.warehouseActionService.cancelPreemption(orderProduct.getProductSpecificationCode(), warehouseCode, quantity);
            }
        } else {
            Validate.isTrue((boolean)previouStatus.equals(OrderStrategyEvent.BeReceived.getEventTarget()), (String)"\u76ee\u524d\u4ec5\u652f\u6301\u3010\u5f85\u6536\u8d27\u3011\u72b6\u6001\u7684\u53d6\u6d88\u8f66\u9500\u8ba2\u5355\u64cd\u4f5c", (Object[])new Object[0]);
        }
        orderInfo.setOrderStatus(OrderStrategyEvent.BeCancel.getEventTarget());
        this.orderInfoRepository.saveAndFlush((Object)orderInfo);
        super.logged(orderInfo.getId(), previouStatus, orderInfo.getOrderStatus());
    }
}

