/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.strategy;

import com.alibaba.fastjson.JSONArray;
import com.bizunited.empower.business.order.entity.OrderAuditLog;
import com.bizunited.empower.business.order.entity.OrderAuditSetting;
import com.bizunited.empower.business.order.entity.OrderInfo;
import com.bizunited.empower.business.order.enums.GoodsBeforePayStatus;
import com.bizunited.empower.business.order.enums.OrderAuditStatus;
import com.bizunited.empower.business.order.repository.OrderInfoRepository;
import com.bizunited.empower.business.order.service.OrderAuditLogService;
import com.bizunited.empower.business.order.service.OrderAuditSettingService;
import com.bizunited.empower.business.order.service.analysis.WarehouseExpenseAnalysis;
import com.bizunited.empower.business.order.service.strategy.OrderAbstractLoggedAbleStrategy;
import com.bizunited.empower.business.order.service.strategy.OrderRoamStrategy;
import com.bizunited.empower.business.order.service.strategy.OrderStrategyEvent;
import com.bizunited.empower.business.warehouse.service.WarehouseProductsExpenseService;
import java.util.List;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="OrderToBeDeliveredRoamStrategy")
public class OrderToBeDeliveredRoamStrategy
extends OrderAbstractLoggedAbleStrategy
implements OrderRoamStrategy {
    @Autowired
    private OrderAuditSettingService orderAuditSettingService;
    @Autowired
    private OrderInfoRepository orderInfoRepository;
    @Autowired
    private OrderAuditLogService orderAuditLogService;
    @Autowired
    private WarehouseProductsExpenseService warehouseProductsExpenseService;
    @Autowired
    private WarehouseExpenseAnalysis warehouseExpenseAnalysis;

    @Override
    public OrderStrategyEvent manualValidate() {
        return OrderStrategyEvent.BeDelivered;
    }

    @Override
    public Boolean automaticValidate(OrderInfo orderInfo) {
        Integer previousOrderStatus = orderInfo.getOrderStatus();
        return previousOrderStatus.equals(OrderStrategyEvent.BeAudit.getEventTarget());
    }

    @Override
    @Transactional
    public void action(OrderInfo orderInfo) {
        Integer previousOrderStatus = orderInfo.getOrderStatus();
        if (previousOrderStatus.equals(OrderStrategyEvent.BeAudit.getEventTarget())) {
            this.actionForward(orderInfo);
            return;
        }
        if (previousOrderStatus.equals(OrderStrategyEvent.BeShipped.getEventTarget()) || previousOrderStatus.equals(OrderStrategyEvent.PartialDelivered.getEventTarget())) {
            this.actionReverse(orderInfo);
        }
    }

    private void actionForward(OrderInfo orderInfo) {
        Integer previousOrderStatus = orderInfo.getOrderStatus();
        OrderAuditSetting auditSetting = this.orderAuditSettingService.findByOrderId(orderInfo.getId());
        if (auditSetting != null) {
            boolean allAuditStatusResult = this.allNodeAuditStatusDone(auditSetting, orderInfo);
            if (!allAuditStatusResult) {
                return;
            }
            if (orderInfo.getPayType().equals(GoodsBeforePayStatus.BEFORE_PAY.getValue()) && orderInfo.getReceivableStatus() != 3) {
                return;
            }
        }
        orderInfo.setOrderStatus(OrderStrategyEvent.BeDelivered.getEventTarget());
        this.orderInfoRepository.saveAndFlush((Object)orderInfo);
        super.logged(orderInfo.getId(), previousOrderStatus, orderInfo.getOrderStatus());
    }

    private void actionReverse(OrderInfo orderInfo) {
        Integer previousOrderStatus = orderInfo.getOrderStatus();
        boolean isAllDone = this.warehouseExpenseAnalysis.validateAllDone(orderInfo, null);
        if (!isAllDone) {
            List expenses = this.warehouseProductsExpenseService.findByRelevanceCode(orderInfo.getOrderCode());
            boolean allWait = (expenses = expenses.stream().filter(e -> e.getState() != 4).collect(Collectors.toList())).stream().allMatch(e -> e.getState() == 1);
            if (allWait) {
                orderInfo.setOrderStatus(OrderStrategyEvent.BeDelivered.getEventTarget());
                this.orderInfoRepository.saveAndFlush((Object)orderInfo);
                super.logged(orderInfo.getId(), previousOrderStatus, OrderStrategyEvent.BeDelivered.getEventTarget());
            }
        }
    }

    private boolean allNodeAuditStatusDone(OrderAuditSetting auditSetting, OrderInfo orderInfo) {
        String auditNodeSetting = auditSetting.getAuditNodeSettings();
        String version = auditSetting.getAuditVersion();
        JSONArray array = JSONArray.parseArray((String)auditNodeSetting);
        if (array == null || array.size() == 0) {
            return true;
        }
        int nodeSize = array.size();
        List<OrderAuditLog> logs = this.orderAuditLogService.findByOrderIdAndVersion(orderInfo.getId(), version);
        if (CollectionUtils.isEmpty(logs) || logs.size() < nodeSize) {
            return false;
        }
        OrderAuditLog log = logs.get(nodeSize - 1);
        return StringUtils.equals((CharSequence)log.getAuditStatus(), (CharSequence)OrderAuditStatus.DONE.name());
    }
}

