/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.strategy;

import com.bizunited.empower.business.distribution.enums.DeliverStatus;
import com.bizunited.empower.business.distribution.service.DeliverGoodVoService;
import com.bizunited.empower.business.order.entity.OrderInfo;
import com.bizunited.empower.business.order.repository.OrderInfoRepository;
import com.bizunited.empower.business.order.service.analysis.WarehouseExpenseAnalysis;
import com.bizunited.empower.business.order.service.strategy.OrderAbstractLoggedAbleStrategy;
import com.bizunited.empower.business.order.service.strategy.OrderRoamStrategy;
import com.bizunited.empower.business.order.service.strategy.OrderStrategyEvent;
import com.bizunited.empower.business.warehouse.service.WarehouseProductsExpenseService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="OrderToBeShippedRoamStrategy")
public class OrderToBeShippedRoamStrategy
extends OrderAbstractLoggedAbleStrategy
implements OrderRoamStrategy {
    @Autowired
    private OrderInfoRepository orderInfoRepository;
    @Autowired
    private WarehouseExpenseAnalysis warehouseExpenseAnalysis;
    @Autowired
    private WarehouseProductsExpenseService warehouseProductsExpenseService;
    @Autowired
    private DeliverGoodVoService deliverGoodVoService;

    @Override
    public OrderStrategyEvent manualValidate() {
        return OrderStrategyEvent.BeShipped;
    }

    @Override
    public Boolean automaticValidate(OrderInfo orderInfo) {
        Integer previousOrderStatus = orderInfo.getOrderStatus();
        return previousOrderStatus.equals(OrderStrategyEvent.BeDelivered.getEventTarget()) || previousOrderStatus.equals(OrderStrategyEvent.PartialDelivered.getEventTarget());
    }

    @Override
    @Transactional
    public void action(OrderInfo orderInfo) {
        Integer previousOrderStatus = orderInfo.getOrderStatus();
        if (previousOrderStatus.equals(OrderStrategyEvent.BeDelivered.getEventTarget()) || previousOrderStatus.equals(OrderStrategyEvent.PartialDelivered.getEventTarget()) || previousOrderStatus.equals(OrderStrategyEvent.PartialShipped.getEventTarget()) || previousOrderStatus.equals(OrderStrategyEvent.BeReceived.getEventTarget())) {
            List warehouseProductsExpenses = this.warehouseProductsExpenseService.findByRelevanceCode(orderInfo.getOrderCode());
            if (CollectionUtils.isEmpty((Collection)warehouseProductsExpenses)) {
                return;
            }
            boolean isAllDone = this.warehouseExpenseAnalysis.validateAllDone(orderInfo, null);
            if (isAllDone) {
                List deliverGoodVos = this.deliverGoodVoService.findByOrderCode(orderInfo.getOrderCode());
                boolean allWait = (deliverGoodVos = deliverGoodVos.stream().filter(e -> !DeliverStatus.CANCEL.getType().equals(e.getDeliverStatus())).collect(Collectors.toList())).stream().allMatch(e -> DeliverStatus.WAIT_DELIVER.getType().equals(e.getDeliverStatus()));
                if (allWait) {
                    orderInfo.setOrderStatus(OrderStrategyEvent.BeShipped.getEventTarget());
                    this.orderInfoRepository.saveAndFlush((Object)orderInfo);
                    super.logged(orderInfo.getId(), previousOrderStatus, orderInfo.getOrderStatus());
                }
            }
        }
    }
}

