/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.strategy;

import com.bizunited.empower.business.order.entity.OrderInfo;
import com.bizunited.empower.business.order.repository.OrderInfoRepository;
import com.bizunited.empower.business.order.service.strategy.OrderAbstractLoggedAbleStrategy;
import com.bizunited.empower.business.order.service.strategy.OrderRoamStrategy;
import com.bizunited.empower.business.order.service.strategy.OrderStrategyEvent;
import com.bizunited.empower.business.payment.service.ReceivableInfoService;
import com.bizunited.empower.business.policy.service.RebateAccountBrandDetailsService;
import com.bizunited.empower.business.policy.service.RebateAccountCommonDetailsService;
import com.bizunited.empower.business.policy.service.RebateAccountProductDetailsService;
import com.bizunited.empower.business.policy.service.SalePolicyResultService;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="OrderToCancelledRoamStrategy")
public class OrderToCancelledRoamStrategy
extends OrderAbstractLoggedAbleStrategy
implements OrderRoamStrategy {
    @Autowired
    private OrderInfoRepository orderInfoRepository;
    @Autowired
    private ReceivableInfoService receivableInfoService;
    @Autowired
    private SalePolicyResultService salePolicyResultService;
    @Autowired
    private RebateAccountBrandDetailsService rebateAccountBrandDetailsService;
    @Autowired
    private RebateAccountCommonDetailsService rebateAccountCommonDetailsService;
    @Autowired
    private RebateAccountProductDetailsService rebateAccountProductDetailsService;

    @Override
    public OrderStrategyEvent manualValidate() {
        return OrderStrategyEvent.Cancelled;
    }

    @Override
    public Boolean automaticValidate(OrderInfo orderInfo) {
        int previousOrderStatus = orderInfo.getOrderStatus();
        return previousOrderStatus == OrderStrategyEvent.BeCancel.getEventTarget();
    }

    @Override
    @Transactional
    public void action(OrderInfo orderInfo) {
        int previousOrderStatus = orderInfo.getOrderStatus();
        if (previousOrderStatus == OrderStrategyEvent.Cancelled.getEventTarget()) {
            return;
        }
        if (previousOrderStatus != OrderStrategyEvent.BeCancel.getEventTarget()) {
            return;
        }
        this.salePolicyResultService.disableByRelevanceCode(orderInfo.getOrderCode());
        this.rebateAccountCommonDetailsService.diffectiveByRelevanceCode(orderInfo.getOrderCode());
        this.rebateAccountBrandDetailsService.diffectiveByRelevanceCode(orderInfo.getOrderCode());
        this.rebateAccountProductDetailsService.diffectiveByRelevanceCode(orderInfo.getOrderCode());
        this.orderInfoRepository.flush();
        this.receivableInfoService.cancelByAssociatedCode(orderInfo.getOrderCode());
        orderInfo.setOrderStatus(OrderStrategyEvent.Cancelled.getEventTarget());
        this.orderInfoRepository.saveAndFlush((Object)orderInfo);
        super.logged(orderInfo.getId(), previousOrderStatus, orderInfo.getOrderStatus());
    }
}

