/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.strategy;

import com.bizunited.empower.business.order.entity.OrderInfo;
import com.bizunited.empower.business.order.repository.OrderInfoRepository;
import com.bizunited.empower.business.order.service.notifier.OrderCompletedEventListener;
import com.bizunited.empower.business.order.service.strategy.OrderAbstractLoggedAbleStrategy;
import com.bizunited.empower.business.order.service.strategy.OrderRoamStrategy;
import com.bizunited.empower.business.order.service.strategy.OrderStrategyEvent;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="OrderToCompletedRoamStrategy")
public class OrderToCompletedRoamStrategy
extends OrderAbstractLoggedAbleStrategy
implements OrderRoamStrategy {
    @Autowired
    private OrderInfoRepository orderInfoRepository;
    @Autowired(required=false)
    private List<OrderCompletedEventListener> orderCompletedEventListeners;

    @Override
    public OrderStrategyEvent manualValidate() {
        return OrderStrategyEvent.Completed;
    }

    @Override
    public Boolean automaticValidate(OrderInfo orderInfo) {
        return this.validate(orderInfo);
    }

    private boolean validate(OrderInfo orderInfo) {
        Integer receivableStatus = orderInfo.getReceivableStatus();
        return receivableStatus == 3 && orderInfo.getOrderStatus().equals(OrderStrategyEvent.Received.getEventTarget());
    }

    @Override
    @Transactional
    public void action(OrderInfo orderInfo) {
        int previousOrderStatus = orderInfo.getOrderStatus();
        if (previousOrderStatus == OrderStrategyEvent.Completed.getEventTarget()) {
            return;
        }
        Validate.isTrue((boolean)this.validate(orderInfo), (String)"\u8ba2\u5355\u6ca1\u6709\u5b8c\u6210\u652f\u4ed8\u548c\u914d\u9001\uff0c\u4e0d\u80fd\u5f3a\u5236\u5b8c\u6210\uff01\uff01", (Object[])new Object[0]);
        orderInfo.setOrderStatus(OrderStrategyEvent.Completed.getEventTarget());
        this.orderInfoRepository.saveAndFlush((Object)orderInfo);
        if (!CollectionUtils.isEmpty(this.orderCompletedEventListeners)) {
            for (OrderCompletedEventListener listenerItem : this.orderCompletedEventListeners) {
                listenerItem.onOrderCompleted(orderInfo);
            }
        }
        super.logged(orderInfo.getId(), previousOrderStatus, orderInfo.getOrderStatus());
    }
}

