/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.strategy;

import com.bizunited.empower.business.order.entity.OrderInfo;
import com.bizunited.empower.business.order.repository.OrderInfoRepository;
import com.bizunited.empower.business.order.service.analysis.WarehouseExpenseAnalysis;
import com.bizunited.empower.business.order.service.strategy.OrderAbstractLoggedAbleStrategy;
import com.bizunited.empower.business.order.service.strategy.OrderRoamStrategy;
import com.bizunited.empower.business.order.service.strategy.OrderStrategyEvent;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="OrderToPartialDeliveredRoamStrategy")
public class OrderToPartialDeliveredRoamStrategy
extends OrderAbstractLoggedAbleStrategy
implements OrderRoamStrategy {
    @Autowired
    private OrderInfoRepository orderInfoRepository;
    @Autowired
    private WarehouseExpenseAnalysis warehouseExpenseAnalysis;

    @Override
    public OrderStrategyEvent manualValidate() {
        return OrderStrategyEvent.PartialDelivered;
    }

    @Override
    public Boolean automaticValidate(OrderInfo orderInfo) {
        Integer previousOrderStatus = orderInfo.getOrderStatus();
        return previousOrderStatus.equals(OrderStrategyEvent.BeDelivered.getEventTarget());
    }

    @Override
    @Transactional
    public void action(OrderInfo orderInfo) {
        boolean isPartialDone;
        Integer previousOrderStatus = orderInfo.getOrderStatus();
        if ((previousOrderStatus.equals(OrderStrategyEvent.BeDelivered.getEventTarget()) || previousOrderStatus.equals(OrderStrategyEvent.BeShipped.getEventTarget())) && (isPartialDone = this.warehouseExpenseAnalysis.validatePartialDone(orderInfo, null))) {
            orderInfo.setOrderStatus(OrderStrategyEvent.PartialDelivered.getEventTarget());
            this.orderInfoRepository.saveAndFlush((Object)orderInfo);
            super.logged(orderInfo.getId(), previousOrderStatus, orderInfo.getOrderStatus());
        }
    }
}

