/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.strategy;

import com.bizunited.empower.business.distribution.enums.DeliverStatus;
import com.bizunited.empower.business.distribution.service.DeliverGoodVoService;
import com.bizunited.empower.business.order.entity.OrderInfo;
import com.bizunited.empower.business.order.repository.OrderInfoRepository;
import com.bizunited.empower.business.order.service.analysis.WarehouseExpenseAnalysis;
import com.bizunited.empower.business.order.service.strategy.OrderAbstractLoggedAbleStrategy;
import com.bizunited.empower.business.order.service.strategy.OrderRoamStrategy;
import com.bizunited.empower.business.order.service.strategy.OrderStrategyEvent;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="OrderToPartialShippedRoamStrategy")
public class OrderToPartialShippedRoamStrategy
extends OrderAbstractLoggedAbleStrategy
implements OrderRoamStrategy {
    @Autowired
    private OrderInfoRepository orderInfoRepository;
    @Autowired
    private DeliverGoodVoService deliverGoodVoService;
    @Autowired
    private WarehouseExpenseAnalysis warehouseExpenseAnalysis;

    @Override
    public OrderStrategyEvent manualValidate() {
        return OrderStrategyEvent.PartialShipped;
    }

    @Override
    public Boolean automaticValidate(OrderInfo orderInfo) {
        Integer previousOrderStatus = orderInfo.getOrderStatus();
        return previousOrderStatus.equals(OrderStrategyEvent.BeShipped.getEventTarget());
    }

    @Override
    @Transactional
    public void action(OrderInfo orderInfo) {
        Integer previousOrderStatus = orderInfo.getOrderStatus();
        if (previousOrderStatus.equals(OrderStrategyEvent.PartialDelivered.getEventTarget()) || previousOrderStatus.equals(OrderStrategyEvent.BeShipped.getEventTarget()) || previousOrderStatus.equals(OrderStrategyEvent.BeReceived.getEventTarget())) {
            return;
        }
        List deliverGoodVos = this.deliverGoodVoService.findByOrderCode(orderInfo.getOrderCode());
        if (CollectionUtils.isEmpty((Collection)deliverGoodVos)) {
            return;
        }
        boolean allDone = this.warehouseExpenseAnalysis.validateAllDone(orderInfo, null);
        deliverGoodVos = deliverGoodVos.stream().filter(e -> !DeliverStatus.CANCEL.getType().equals(e.getDeliverStatus())).collect(Collectors.toList());
        boolean hasWait = deliverGoodVos.stream().anyMatch(e -> DeliverStatus.WAIT_DELIVER.getType().equals(e.getDeliverStatus()));
        boolean hasReceived = deliverGoodVos.stream().anyMatch(e -> DeliverStatus.ALREADY_RECEIVE.getType().equals(e.getDeliverStatus()));
        boolean hasDeliver = deliverGoodVos.stream().anyMatch(e -> DeliverStatus.ALREADY_DELIVER.getType().equals(e.getDeliverStatus()));
        if (allDone && (hasDeliver || hasWait && hasReceived)) {
            orderInfo.setOrderStatus(OrderStrategyEvent.PartialShipped.getEventTarget());
            this.orderInfoRepository.saveAndFlush((Object)orderInfo);
            super.logged(orderInfo.getId(), previousOrderStatus, orderInfo.getOrderStatus());
        }
    }
}

