/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.strategy;

import com.bizunited.empower.business.distribution.enums.DeliverStatus;
import com.bizunited.empower.business.distribution.service.DeliverGoodVoService;
import com.bizunited.empower.business.order.entity.OrderInfo;
import com.bizunited.empower.business.order.repository.OrderInfoRepository;
import com.bizunited.empower.business.order.service.analysis.WarehouseExpenseAnalysis;
import com.bizunited.empower.business.order.service.strategy.OrderAbstractLoggedAbleStrategy;
import com.bizunited.empower.business.order.service.strategy.OrderRoamStrategy;
import com.bizunited.empower.business.order.service.strategy.OrderStrategyEvent;
import java.util.List;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="OrderToReceivedRoamStrategy")
public class OrderToReceivedRoamStrategy
extends OrderAbstractLoggedAbleStrategy
implements OrderRoamStrategy {
    @Autowired
    private OrderInfoRepository orderInfoRepository;
    @Autowired
    private WarehouseExpenseAnalysis warehouseExpenseAnalysis;
    @Autowired
    private DeliverGoodVoService deliverGoodVoService;

    @Override
    public OrderStrategyEvent manualValidate() {
        return OrderStrategyEvent.Received;
    }

    @Override
    public Boolean automaticValidate(OrderInfo orderInfo) {
        Integer previousOrderStatus = orderInfo.getOrderStatus();
        return previousOrderStatus.equals(OrderStrategyEvent.BeReceived.getEventTarget());
    }

    @Override
    @Transactional
    public void action(OrderInfo orderInfo) {
        Integer previousOrderStatus = orderInfo.getOrderStatus();
        if (!previousOrderStatus.equals(OrderStrategyEvent.BeReceived.getEventTarget())) {
            return;
        }
        if (orderInfo.getOrderType() == 2) {
            if (orderInfo.getDeliveryStatus() == 3) {
                orderInfo.setOrderStatus(OrderStrategyEvent.Received.getEventTarget());
                this.orderInfoRepository.saveAndFlush((Object)orderInfo);
                super.logged(orderInfo.getId(), previousOrderStatus, orderInfo.getOrderStatus());
            }
            return;
        }
        List deliverGoodVos = this.deliverGoodVoService.findByOrderCode(orderInfo.getOrderCode());
        boolean allDone = this.warehouseExpenseAnalysis.validateAllDone(orderInfo, null);
        if (!allDone) {
            return;
        }
        boolean allReceived = (deliverGoodVos = deliverGoodVos.stream().filter(e -> !DeliverStatus.CANCEL.getType().equals(e.getDeliverStatus())).collect(Collectors.toList())).stream().allMatch(e -> DeliverStatus.ALREADY_RECEIVE.getType().equals(e.getDeliverStatus()));
        if (allReceived) {
            orderInfo.setOrderStatus(OrderStrategyEvent.Received.getEventTarget());
            this.orderInfoRepository.saveAndFlush((Object)orderInfo);
            super.logged(orderInfo.getId(), previousOrderStatus, orderInfo.getOrderStatus());
        }
    }
}

