/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.strategy;

import com.bizunited.empower.business.order.entity.ReturnAuditLog;
import com.bizunited.empower.business.order.entity.ReturnInfo;
import com.bizunited.empower.business.order.enums.ReturnAuditStatus;
import com.bizunited.empower.business.order.repository.ReturnInfoRepository;
import com.bizunited.empower.business.order.service.strategy.ReturnAbstractLoggedAbleStrategy;
import com.bizunited.empower.business.order.service.strategy.ReturnRoamStrategy;
import com.bizunited.empower.business.order.service.strategy.ReturnStrategyEvent;
import java.util.Set;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="ReturnToBeReceivedRoamStrategy")
public class ReturnToBeReceivedRoamStrategy
extends ReturnAbstractLoggedAbleStrategy
implements ReturnRoamStrategy {
    @Autowired
    private ReturnInfoRepository returnInfoRepository;

    @Override
    public ReturnStrategyEvent manualValidate() {
        return ReturnStrategyEvent.BeReceived;
    }

    @Override
    public Boolean automaticValidate(ReturnInfo returnInfo) {
        Set<ReturnAuditLog> auditLogs = returnInfo.getReturnAuditLogs();
        if (!CollectionUtils.isEmpty(auditLogs)) {
            ReturnAuditLog auditLog = auditLogs.iterator().next();
            return ReturnAuditStatus.match(auditLog.getAuditStatus(), ReturnAuditStatus.DONE) && returnInfo.getDeliveryStatus() == 1;
        }
        return false;
    }

    @Override
    @Transactional
    public void action(ReturnInfo returnInfo) {
        int previousReturnStatus = returnInfo.getReturnStatus();
        if (previousReturnStatus == ReturnStrategyEvent.BeReceived.getEventTarget()) {
            return;
        }
        Integer previouStatus = returnInfo.getReturnStatus();
        returnInfo.setReturnStatus(ReturnStrategyEvent.BeReceived.getEventTarget());
        this.returnInfoRepository.save((Object)returnInfo);
        this.logged(returnInfo.getId(), previouStatus, returnInfo.getReturnStatus());
    }
}

