/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.strategy;

import com.bizunited.empower.business.order.entity.OrderInfo;
import com.bizunited.empower.business.order.entity.ReturnAuditLog;
import com.bizunited.empower.business.order.entity.ReturnInfo;
import com.bizunited.empower.business.order.enums.ReturnAuditStatus;
import com.bizunited.empower.business.order.repository.ReturnInfoRepository;
import com.bizunited.empower.business.order.service.strategy.ReturnAbstractLoggedAbleStrategy;
import com.bizunited.empower.business.order.service.strategy.ReturnRoamStrategy;
import com.bizunited.empower.business.order.service.strategy.ReturnStrategyEvent;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="ReturnToBeRefundedRoamStrategy")
public class ReturnToBeRefundedRoamStrategy
extends ReturnAbstractLoggedAbleStrategy
implements ReturnRoamStrategy {
    @Autowired
    private ReturnInfoRepository returnInfoRepository;

    @Override
    public ReturnStrategyEvent manualValidate() {
        return ReturnStrategyEvent.BeRefunded;
    }

    @Override
    public Boolean automaticValidate(ReturnInfo returnInfo) {
        Set<ReturnAuditLog> auditLogs = returnInfo.getReturnAuditLogs();
        if (!CollectionUtils.isEmpty(auditLogs)) {
            ReturnAuditLog auditLog = auditLogs.iterator().next();
            int deliveryStatus = returnInfo.getDeliveryStatus();
            int paymentStatus = returnInfo.getPaymentStatus();
            String auditStatus = auditLog.getAuditStatus();
            return ReturnAuditStatus.match(auditStatus, ReturnAuditStatus.DONE) && deliveryStatus == 2 && paymentStatus != 3;
        }
        return false;
    }

    @Override
    @Transactional
    public void action(ReturnInfo returnInfo) {
        int previousReturnStatus = returnInfo.getReturnStatus();
        if (previousReturnStatus == ReturnStrategyEvent.BeRefunded.getEventTarget()) {
            return;
        }
        String auditStatus = null;
        Set<ReturnAuditLog> auditLogs = returnInfo.getReturnAuditLogs();
        if (!CollectionUtils.isEmpty(auditLogs)) {
            ReturnAuditLog auditLog = auditLogs.iterator().next();
            auditStatus = auditLog.getAuditStatus();
        }
        Integer paymentStatus = returnInfo.getPaymentStatus();
        Validate.isTrue((previousReturnStatus == ReturnStrategyEvent.BeReceived.getEventTarget() && ReturnAuditStatus.match(auditStatus, ReturnAuditStatus.DONE) ? 1 : 0) != 0, (String)"\u5f53\u524d\u9000\u8d27\u5355\u4e0d\u80fd\u8fdb\u884c\u9000\u6b3e\u64cd\u4f5c\uff0c\u53ea\u6709\u5df2\u88ab\u5ba1\u6838\u901a\u8fc7\u7684\u9000\u8d27\u5355\u80fd\u591f\u8fdb\u884c\u9000\u6b3e\u64cd\u4f5c!", (Object[])new Object[0]);
        OrderInfo currentOrderInfo = returnInfo.getOrderInfo();
        boolean relationOrder = returnInfo.getRelationOrder();
        Validate.isTrue((relationOrder && currentOrderInfo != null || !relationOrder && currentOrderInfo == null ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u9000\u8d27\u5355\u5173\u8054\u8ba2\u5355\u72b6\u6001\uff0c\u8bf7\u68c0\u67e5\u9000\u8d27\u5355\u4fe1\u606f!!", (Object[])new Object[0]);
        returnInfo.setReturnStatus(ReturnStrategyEvent.BeRefunded.getEventTarget());
        this.returnInfoRepository.saveAndFlush((Object)returnInfo);
        super.logged(returnInfo.getId(), previousReturnStatus, returnInfo.getReturnStatus());
    }
}

