/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.strategy;

import com.bizunited.empower.business.customer.service.CustomerService;
import com.bizunited.empower.business.order.entity.ReturnInfo;
import com.bizunited.empower.business.order.repository.ReturnInfoRepository;
import com.bizunited.empower.business.order.service.strategy.ReturnAbstractLoggedAbleStrategy;
import com.bizunited.empower.business.order.service.strategy.ReturnRoamStrategy;
import com.bizunited.empower.business.order.service.strategy.ReturnStrategyEvent;
import com.bizunited.empower.business.payment.common.enums.PaymentType;
import com.bizunited.empower.business.payment.service.PaymentInfoService;
import com.bizunited.empower.business.warehouse.service.WarehouseProductsEnterService;
import com.bizunited.platform.common.service.redis.RedisMutexService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="returnToBeReviewedRoamStrategy")
public class ReturnToBeReviewedRoamStrategy
extends ReturnAbstractLoggedAbleStrategy
implements ReturnRoamStrategy {
    private static final String RETURN_CODE_PREFIX = "TH";
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private ReturnInfoRepository returnInfoRepository;
    @Autowired
    private WarehouseProductsEnterService warehouseProductsEnterService;
    @Autowired
    private CustomerService customerService;
    @Autowired
    private PaymentInfoService paymentInfoService;

    @Override
    public ReturnStrategyEvent manualValidate() {
        return ReturnStrategyEvent.BeReviewed;
    }

    @Override
    public Boolean automaticValidate(ReturnInfo returnInfo) {
        if (returnInfo.getReturnStatus() != null) {
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public void action(ReturnInfo returnInfo) {
        if (returnInfo.getReturnStatus() != null && returnInfo.getReturnStatus().equals(ReturnStrategyEvent.BeReviewed.getEventTarget())) {
            return;
        }
        Date now = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        String datecode = dateFormat.format(now);
        returnInfo.setReturnStatus(ReturnStrategyEvent.BeReviewed.getEventTarget());
        String tenantCode = TenantUtils.getTenantCode();
        String codeUnKey = StringUtils.join((Object[])new String[]{RETURN_CODE_PREFIX, "_", tenantCode});
        String atomicNumberValue = this.redisMutexService.getAndIncrement(codeUnKey, 1L, Integer.valueOf(6), 25L, TimeUnit.HOURS);
        String returnCode = StringUtils.join((Object[])new String[]{RETURN_CODE_PREFIX, datecode, atomicNumberValue});
        returnInfo.setReturnCode(returnCode);
        this.returnInfoRepository.saveAndFlush((Object)returnInfo);
        this.paymentInfoService.createByAssociatedCode(returnInfo.getCustomerCode(), returnInfo.getReturnCode(), returnInfo.getReturnTotalPrice(), PaymentType.RETURN);
        super.logged(returnInfo.getId(), null, returnInfo.getReturnStatus());
    }
}

