/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.strategy;

import com.bizunited.empower.business.order.entity.OrderInfo;
import com.bizunited.empower.business.order.entity.OrderProduct;
import com.bizunited.empower.business.order.entity.ReturnInfo;
import com.bizunited.empower.business.order.entity.ReturnProduct;
import com.bizunited.empower.business.order.repository.OrderInfoRepository;
import com.bizunited.empower.business.order.repository.ReturnInfoRepository;
import com.bizunited.empower.business.order.service.notifier.ReturnCompletedEventListener;
import com.bizunited.empower.business.order.service.strategy.ReturnAbstractLoggedAbleStrategy;
import com.bizunited.empower.business.order.service.strategy.ReturnRoamStrategy;
import com.bizunited.empower.business.order.service.strategy.ReturnStrategyEvent;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="ReturnToCompletedRoamStrategy")
public class ReturnToCompletedRoamStrategy
extends ReturnAbstractLoggedAbleStrategy
implements ReturnRoamStrategy {
    @Autowired(required=false)
    private List<ReturnCompletedEventListener> returnCompletedEventListeners;
    @Autowired
    private ReturnInfoRepository returnInfoRepository;
    @Autowired
    private OrderInfoRepository orderInfoRepository;

    @Override
    public ReturnStrategyEvent manualValidate() {
        return ReturnStrategyEvent.Completed;
    }

    @Override
    public Boolean automaticValidate(ReturnInfo returnInfo) {
        return this.validate(returnInfo);
    }

    private boolean validate(ReturnInfo returnInfo) {
        int paymentStatus = returnInfo.getPaymentStatus();
        int deliveryStatus = returnInfo.getDeliveryStatus();
        return paymentStatus == 3 && deliveryStatus == 2;
    }

    @Override
    @Transactional
    public void action(ReturnInfo returnInfo) {
        long validate;
        int previousReturnStatus = returnInfo.getReturnStatus();
        if (previousReturnStatus == ReturnStrategyEvent.Completed.getEventTarget()) {
            return;
        }
        Validate.isTrue((boolean)this.validate(returnInfo), (String)"\u9000\u8d27\u5355\u53ea\u6709\u5728\u5df2\u6536\u8d27\u3001\u5df2\u4ed8\u6b3e\u7684\u60c5\u51b5\u4e0b\uff0c\u624d\u80fd\u6700\u7ec8\u88ab\u8bbe\u7f6e\u4e3a\u5b8c\u6210\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        int previouStatus = returnInfo.getReturnStatus();
        if (this.returnCompletedEventListeners != null && (validate = this.returnCompletedEventListeners.stream().filter(item -> item.validate(returnInfo) == false).count()) > 0L) {
            throw new IllegalArgumentException("\u6709\u4e0a\u5c42\u4e1a\u52a1\u4e0d\u5141\u8bb8\u5f53\u524d\u9000\u8d27\u5355\u6b63\u5f0f\u7ed3\u675f\uff0c\u8bf7\u68c0\u67e5!!");
        }
        returnInfo.setReturnStatus(ReturnStrategyEvent.Completed.getEventTarget());
        this.returnInfoRepository.saveAndFlush((Object)returnInfo);
        if (this.returnCompletedEventListeners != null) {
            for (ReturnCompletedEventListener item2 : this.returnCompletedEventListeners) {
                item2.onReturnCompleted(returnInfo);
            }
        }
        if (returnInfo.getOrderInfo() != null) {
            this.writeBackReturnAllCompleted(returnInfo);
        }
        this.logged(returnInfo.getId(), previouStatus, returnInfo.getReturnStatus());
    }

    private void writeBackReturnAllCompleted(ReturnInfo returnInfo) {
        OrderInfo orderInfo = returnInfo.getOrderInfo();
        Set<ReturnProduct> returnProducts = returnInfo.getReturnProducts();
        Validate.isTrue((!CollectionUtils.isEmpty(returnProducts) ? 1 : 0) != 0, (String)"\u9000\u8d27\u5355\u81f3\u5c11\u9700\u8981\u4e00\u6761\u5546\u54c1\u4fe1\u606f!!", (Object[])new Object[0]);
        Set<ReturnInfo> dbReturnInfos = this.returnInfoRepository.findDetailsByOrderId(orderInfo.getId());
        dbReturnInfos = dbReturnInfos.stream().filter(e -> !ReturnStrategyEvent.Cancelled.getEventTarget().equals(e.getReturnStatus())).collect(Collectors.toSet());
        Map<String, BigDecimal> orderInfoProducts = orderInfo.getOrderProducts().stream().collect(Collectors.toMap(e1 -> StringUtils.joinWith((String)",", (Object[])new Object[]{e1.getProductSpecificationCode(), e1.getUnitCode(), e1.getGift()}), OrderProduct::getOrderQuantity));
        HashMap dbReturnInfoProducts = Maps.newHashMap();
        for (ReturnInfo dbReturnInfo : dbReturnInfos) {
            Set<ReturnProduct> products = dbReturnInfo.getReturnProducts();
            for (ReturnProduct product : products) {
                String key = StringUtils.joinWith((String)",", (Object[])new Object[]{product.getProductSpecificationCode(), product.getUnitCode(), product.getGift()});
                if (dbReturnInfoProducts.containsKey(key)) {
                    dbReturnInfoProducts.put(key, ((BigDecimal)dbReturnInfoProducts.get(key)).add(product.getReturnQuantity()));
                    continue;
                }
                dbReturnInfoProducts.put(key, product.getReturnQuantity());
            }
        }
        Validate.isTrue((boolean)orderInfoProducts.keySet().containsAll(dbReturnInfoProducts.keySet()), (String)"\u5f53\u524d\u9000\u8d27\u5355\u542b\u6709\u4e0d\u5c5e\u4e8e\u539f\u8ba2\u5355\u7684\u5546\u54c1\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        boolean isWriteBack = true;
        for (Map.Entry<String, BigDecimal> entry : orderInfoProducts.entrySet()) {
            String key = entry.getKey();
            if (!dbReturnInfoProducts.containsKey(key) || entry.getValue().compareTo((BigDecimal)dbReturnInfoProducts.get(key)) == 0) continue;
            isWriteBack = false;
            break;
        }
        if (isWriteBack) {
            this.orderInfoRepository.updateReturnAllCompleted(orderInfo.getId());
        }
    }
}

