package com.bizunited.empower.business.payment.common.constant;

import com.bizunited.empower.business.payment.common.enums.ElAccountBillBusinessType;
import com.bizunited.empower.business.payment.common.enums.WalletBillBusinessType;
import com.google.common.collect.Sets;

import java.util.Set;

import static com.bizunited.empower.business.payment.common.enums.WalletBillBusinessType.PAYMENT;
import static com.bizunited.empower.business.payment.common.enums.WalletBillBusinessType.RECHARGE;
import static com.bizunited.empower.business.payment.common.enums.WalletBillBusinessType.REFUND;
import static com.bizunited.empower.business.payment.common.enums.WalletBillBusinessType.TRANSFER_BALANCE;
import static com.bizunited.empower.business.payment.common.enums.WalletBillBusinessType.WITHDRAW;

/**
 * @Author: Paul Chan
 * @Date: 2021/2/22 下午4:12
 */
public class Constants {

  private Constants() {
    throw new IllegalStateException("静态变量类不能进行实例化");
  }

  /**
   * 应收账款编码前缀
   */
  public static final String RECEIVABLE_INFO_NO_PREFIX = "YS";
  /**
   * 采购应收账款编码前缀
   */
  public static final String SUPPLIER_RECEIVABLE_INFO_NO_PREFIX = "CGYS";
  /**
   * 收款单编码前缀
   */
  public static final String RECEIPT_INFO_NO_PREFIX = "SK";
  /**
   * 应付账款编码前缀
   */
  public static final String PAYMENT_INFO_NO_PREFIX = "YF";
  /**
   * 采购应付账款编码前缀
   */
  public static final String SUPPLIER_PAYMENT_INFO_NO_PREFIX = "CGYF";
  /**
   * 付款单编码前缀
   */
  public static final String DEFRAY_INFO_NO_PREFIX = "FK";

  /**
   * 对账单编码前缀
   */
  public static final String RECONCILIATION_NO_PREFIX = "DZ";

  /**
   * 电子钱包流水编号前缀
   */
  public static final String WALLET_BILL_NO_PREFIX = "YE";

  /**
   * 客户信用流水单号前缀
   */
  public static final String CUSTOMER_CREDIT_BILL_NO_PREFIX = "XY";

  /**
   * 收款的业务类型
   */
  public static final Set<WalletBillBusinessType> WALLET_BILL_BUSINESS_TYPE_RECEIPT = Sets.newHashSet(PAYMENT, WITHDRAW);

  /**
   * 恢复额度的业务类型
   */
  public static final Set<WalletBillBusinessType> WALLET_BILL_BUSINESS_TYPE_RECOVER = Sets.newHashSet(RECHARGE, TRANSFER_BALANCE, REFUND);

  /**
   * 电子账户收入
   */
  public static final Set<ElAccountBillBusinessType> EL_ACCOUNT_BILL_BUSINESS_TYPE_RECEIPT = Sets.newHashSet(ElAccountBillBusinessType.RECEIPT, ElAccountBillBusinessType.SERVICE_CHARGE_REFUND);

  /**
   * 电子账户支出
   */
  public static final Set<ElAccountBillBusinessType> EL_ACCOUNT_BILL_BUSINESS_TYPE_PAYMENT = Sets.newHashSet(ElAccountBillBusinessType.WITHDRAW, ElAccountBillBusinessType.REFUND, ElAccountBillBusinessType.SERVICE_CHARGE_PAYMENT);

}
