package com.bizunited.empower.business.payment.common.constant;

/**
 * 资金模块 redis key管理
 *
 * @author Keller
 */
public class RedisKeys {

  private RedisKeys() {
    throw new IllegalStateException("静态变量类不能进行实例化");
  }

  /**
   * 应收账款锁前缀，后面拼接应收账款单号
   */
  public static final String RECEIVABLE_INFO_LOCK_PREFIX = "lock:receivable:%s:%s";

  /**
   * 应收账款订单创建锁前缀，后面拼接订单号
   */
  public static final String RECEIVABLE_ORDER_LOCK_PREFIX = "lock:receivable:order:%s:%s";

  /**
   * 应收账款订单创建锁前缀，后面拼接订单号
   */
  public static final String SUPPLIER_RECEIVABLE_ORDER_LOCK_PREFIX = "lock:supplier:receivable:order:%s:%s";

  /**
   * 收款单创建锁前缀，后面拼接订单号
   */
  public static final String RECEIPT_INFO_LOCK_PREFIX = "lock:receipt:order:%s:%s";

  /**
   * 应收账款流水单号KEY,后面拼接日期的年月日(yyyMMdd) 每日流水号重置
   */
  public static final String RECEIVABLE_INFO_NO_KEY_PREFIX = "receivable:no:%s:%s";

  /**
   * 供应商应收账款流水单号KEY,后面拼接日期的年月日(yyyMMdd) 每日流水号重置
   */
  public static final String SUPPLIER_RECEIVABLE_INFO_NO_KEY_PREFIX = "supplier:receivable:no:%s:%s";

  /**
   * 供应商应付账款流水单号KEY,后面拼接日期的年月日(yyyMMdd) 每日流水号重置
   */
  public static final String SUPPLIER_PAYMENT_INFO_NO_KEY_PREFIX = "supplier:payment:no:%s:%s";

  /**
   * 收款单流水单号KEY,后面拼接日期的年月日(yyyMMdd) 每日流水号重置
   */
  public static final String RECEIPT_INFO_NO_KEY_PREFIX = "receipt:no:%s:%s";

  /**
   * 应付账款锁前缀，后面拼接应收账款单号
   */
  public static final String PAYMENT_INFO_LOCK_PREFIX = "lock:payment:%s:%s";

  /**
   * 应付账款订单创建锁前缀，后面拼接订单号
   */
  public static final String PAYMENT_ORDER_LOCK_PREFIX = "lock:payment:order:%s:%s";

  /**
   * 应付账款订单创建锁前缀，后面拼接订单号
   */
  public static final String SUPPLIER_PAYMENT_ORDER_LOCK_PREFIX = "lock:supplier:payment:order:%s:%s";

  /**
   * 应付账款流水单号KEY,后面拼接日期的年月日(yyyyMMdd) 每日流水号重置
   */
  public static final String PAYMENT_INFO_NO_KEY_PREFIX = "payment:no:%s:%s";

  /**
   * 付款单流水单号KEY,后面拼接日期的年月日(yyyyMMdd) 每日流水号重置
   */
  public static final String DEFRAY_INFO_NO_KEY_PREFIX = "defray:no:%s:%s";

  /**
   * 对账单流水单号KEY,后面拼接日期的年月日(yyyyMMdd) 每日流水号重置
   * TODO 预留 对账单时使用
   */
  public static final String RECONCILIATION_NO_KEY_PREFIX = "reconciliation:no:%s:%s";

  /**
   * 客户信用锁前缀，后面拼接客户编码
   * 第一个参数：经销商编码
   * 第二个参数：客户编码
   */
  public static final String CUSTOMER_CREDIT_LOCK_PREFIX = "lock:customer:credit:%s:%s";

  /**
   * 客户信用流水单单号KEY,
   * 第一个参数：经销商编码
   * 第二个参数：日期的年月日（yyyyMMdd）
   */
  public static final String CUSTOMER_CREDIT_BILL_NO_KEY_PREFIX = "customer:credit:bill:no:%s:%s";

  /**
   * 客户电子钱包redis锁
   * 第一个参数：经销商编码
   * 第二个参数：客户编码
   */
  public static final String CUSTOMER_WALLET_LOCK_PREFIX = "lock:customer:wallet:%s:%s";

  /**
   * 电子钱包流水编号key
   * 第一个参数：经销商编码
   * 第二个参数：日期的年月日（yyyyMMdd）
   */
  public static final String CUSTOMER_WALLET_BILL_NO_INDEX = "customer:wallet:bill:no:%s:%s";

  /**
   * 经销商电子账户手机号验证码key
   * 第一个参数：经销商编码
   * 第二个参数：业务类型
   */
  public static final String TENANT_SMS_EL_ACCOUNT_MOBILE_CODE_KEY =  "tenant:sms:elAccount:mobile:code:%s:%d";

  /**
   * 经销商电子账户流水号key
   * 第一个参数：厂商编码
   * 第二个参数：日期（yyyyMMdd）
   */
  public static final String TENANT_EL_ACCOUNT_BILL_NO_KEY = "tenant:elAccount:bill:no:%s:%s";

  /**
   * 经销商电子账户redis锁
   * 第一个参数：经销商编码
   */
  public static final String TENANT_EL_ACCOUNT_LOCK_PREFIX = "lock:tenant:elAccount:%s";

  /**
   * 经销商电子账户流水redis锁
   * 第一个参数：经销商编码
   * 第二个参数：流水编码
   */
  public static final String TENANT_EL_ACCOUNT_BILL_LOCK_PREFIX = "lock:tenant:elAccount:bill:%s:%s";

  /**
   * 经销商电子账户流水redis锁
   * 第一个参数：经销商编码
   * 第二个参数：业务编码
   */
  public static final String TENANT_EL_ACCOUNT_BILL_BUSINESS_LOCK_PREFIX = "lock:tenant:elAccount:bill:business:%s:%s";
}
