package com.bizunited.empower.business.payment.common.enums;

/**
 * 客户信用流水账单类型
 *
 * @Author: Paul Chan
 * @Date: 2021/2/24 上午10:27
 */
public enum CustomerCreditBillType {
  RECEIPT(1, "收款"),
  RECOVER(2, "恢复额度");

  /**
   * 类型
   */
  private Integer type;

  /**
   * 说明
   */
  private String desc;

  CustomerCreditBillType(Integer type, String desc) {
    this.type = type;
    this.desc = desc;
  }

  /**
   * 根据流水单类型值获取相应的枚举
   * @param type
   * @return
   */
  public static CustomerCreditBillType valueOfType(Integer type) {
    if(type == null) {
      return null;
    }
    for (CustomerCreditBillType value : values()) {
      if(value.type.equals(type)) {
        return value;
      }
    }
    return null;
  }


  public Integer getType() {
    return type;
  }

  public String getDesc() {
    return desc;
  }
}
