package com.bizunited.empower.business.payment.common.enums;

/**
 * 客户电子钱包流水账单类型
 *
 * @Author: Paul Chan
 * @Date: 2021/2/24 上午10:27
 */
public enum CustomerWalletBillType {
  RECEIPT(1, "收款"),
  RECOVER(2, "恢复额度");

  /**
   * 类型
   */
  private Integer type;

  /**
   * 说明
   */
  private String desc;

  CustomerWalletBillType(Integer type, String desc) {
    this.type = type;
    this.desc = desc;
  }

  /**
   * 根据流水单类型值获取相应的枚举
   * @param type
   * @return
   */
  public static CustomerWalletBillType valueOfType(Integer type) {
    if(type == null) {
      return null;
    }
    for (CustomerWalletBillType value : values()) {
      if(value.type.equals(type)) {
        return value;
      }
    }
    return null;
  }


  public Integer getType() {
    return type;
  }

  public String getDesc() {
    return desc;
  }
}
