package com.bizunited.empower.business.payment.common.enums;

/**
 * 电子账户流水账单业务类型
 *
 * 业务类型，1：提现、2：收款、3：退款、4：服务费收款、5：服务费退款
 *
 * @Author: Paul Chan
 * @Date: 2021/2/24 上午10:27
 */
public enum ElAccountBillBusinessType {
  WITHDRAW(1, "提现", "TX"),
  RECEIPT(2, "应收", "DS"),
  REFUND(3, "退货退款", "DT"),
  SERVICE_CHARGE_PAYMENT(4, "服务费收款", "FS"),
  SERVICE_CHARGE_REFUND(5, "服务费退款", "FT");

  /**
   * 类型
   */
  private Integer type;

  /**
   * 说明
   */
  private String desc;

  /**
   * 流水号前缀
   */
  private String prefix;

  ElAccountBillBusinessType(Integer type, String desc, String prefix) {
    this.type = type;
    this.desc = desc;
    this.prefix = prefix;
  }

  /**
   * 根据流水单类型值获取相应的枚举
   * @param type
   * @return
   */
  public static ElAccountBillBusinessType valueOfType(Integer type) {
    if(type == null) {
      return null;
    }
    for (ElAccountBillBusinessType value : values()) {
      if(value.type.equals(type)) {
        return value;
      }
    }
    return null;
  }


  public Integer getType() {
    return type;
  }

  public String getDesc() {
    return desc;
  }

  public String getPrefix() {
    return prefix;
  }
}
