package com.bizunited.empower.business.payment.common.enums;

/**
 * 电子账户流水账单手续费类型
 *
 * @Author: Paul Chan
 * @Date: 2021/2/24 上午10:27
 */
public enum ElAccountBillChargeRateType {
  RATE(1, "比率"),
  AMOUNT(2, "固定金额");

  /**
   * 类型
   */
  private Integer type;

  /**
   * 说明
   */
  private String desc;

  ElAccountBillChargeRateType(Integer type, String desc) {
    this.type = type;
    this.desc = desc;
  }

  /**
   * 根据流水单类型值获取相应的枚举
   * @param type
   * @return
   */
  public static ElAccountBillChargeRateType valueOfType(Integer type) {
    if(type == null) {
      return null;
    }
    for (ElAccountBillChargeRateType value : values()) {
      if(value.type.equals(type)) {
        return value;
      }
    }
    return null;
  }


  public Integer getType() {
    return type;
  }

  public String getDesc() {
    return desc;
  }
}
