package com.bizunited.empower.business.payment.common.enums;

/**
 * 客户账户流水账单状态
 *
 * @Author: Paul Chan
 * @Date: 2021/2/24 上午10:27
 */
public enum ElAccountBillState {
  HANDLING(0, "处理中"),
  SUCCESS(1, "成功"),
  FAILURE(2, "失败");

  /**
   * 类型
   */
  private Integer state;

  /**
   * 说明
   */
  private String desc;

  ElAccountBillState(Integer state, String desc) {
    this.state = state;
    this.desc = desc;
  }

  /**
   * 根据流水单类型值获取相应的枚举
   * @param state
   * @return
   */
  public static ElAccountBillState valueOfState(Integer state) {
    if(state == null) {
      return null;
    }
    for (ElAccountBillState value : values()) {
      if(value.state.equals(state)) {
        return value;
      }
    }
    return null;
  }


  public Integer getState() {
    return state;
  }

  public String getDesc() {
    return desc;
  }
}
