package com.bizunited.empower.business.payment.common.enums;

/**
 * 电子账户流水账单类型
 *
 * @Author: Paul Chan
 * @Date: 2021/2/24 上午10:27
 */
public enum ElAccountBillType {
  RECEIPT(1, "收入"),
  PAYMENT(2, "支出");

  /**
   * 类型
   */
  private Integer type;

  /**
   * 说明
   */
  private String desc;

  ElAccountBillType(Integer type, String desc) {
    this.type = type;
    this.desc = desc;
  }

  /**
   * 根据流水单类型值获取相应的枚举
   * @param type
   * @return
   */
  public static ElAccountBillType valueOfType(Integer type) {
    if(type == null) {
      return null;
    }
    for (ElAccountBillType value : values()) {
      if(value.type.equals(type)) {
        return value;
      }
    }
    return null;
  }


  public Integer getType() {
    return type;
  }

  public String getDesc() {
    return desc;
  }
}
