package com.bizunited.empower.business.payment.common.enums;

/**
 * 电子账户申请状态
 * 1：待审核，2：审核失败，3：预审成功，4：采集失败，5：待开户，17：开户中，6：开户失败，7：待绑卡，8：绑卡失败，9：待验证
 * ，10：验证失败，11：待签约，12：签约失败，13：待进件，14：进件中，15：进件失败，16：已启用
 *
 * 个体户申请状态流转过程：
 * 待审核 -> 审核失败(预审成功) -> 待绑卡(绑卡失败) -> 待验证(验证失败)
 * -> 待开户(开户中，开户失败) -> 待签约(签约失败) -> 待进件(进件中,进件失败) -> 已启用
 * @Author: Paul Chan
 * @Date: 2021/4/8 下午4:19
 */
public enum ElectronicAccountApplyState {
  WAIT_PRE_APPLY(1, "待审核"),
  PRE_APPLY_FAILURE(2, "审核失败"),
  PRE_APPLY_SUCCESS(3, "预审成功"),
  COLLECT_FAILURE(4, "采集失败"),
  WAIT_OPEN_ACCOUNT(5, "待开户"),
  OPEN_ACCOUNT_FAILURE(6, "开户失败"),
  WAIT_TIED_CARD(7, "待绑卡"),
  TIED_CARD_FAILURE(8, "绑卡失败"),
  WAIT_VERIFY(9, "待验证"),
  VERIFY_FAILURE(10, "验证失败"),
  WAIT_SIGN(11, "待签约"),
  SIGN_FAILURE(12, "签约失败"),
  WAIT_INTO(13, "待进件"),
  INTO_ING(14, "进件中"),
  INTO_FAILURE(15, "进件失败"),
  END(16, "已启用"),
  OPEN_ACCOUNT_ING(17, "开户中");

  private Integer state;

  private String desc;

  ElectronicAccountApplyState(Integer state, String desc) {
    this.state = state;
    this.desc = desc;
  }

  /**
   * 根据状态获取枚举值
   * @param state
   * @return
   */
  public static ElectronicAccountApplyState valueOfState(Integer state) {
    if(state == null) {
      return null;
    }
    for (ElectronicAccountApplyState value : values()) {
      if(value.state.equals(state)) {
        return value;
      }
    }
    return null;
  }

  public Integer getState() {
    return state;
  }

  public String getDesc() {
    return desc;
  }
}
