package com.bizunited.empower.business.payment.common.enums;

/**
 * 电子账户银行信息状态
 * 状态：0：待验证，1：正常，2：已解绑
 * @Author: Paul Chan
 * @Date: 2021/4/12 下午1:58
 */
public enum ElectronicAccountBankState {
  WAITING_VALID(0, "待验证"),
  ENABLE(1, "正常"),
  UNBOUND(2, "已解绑");

  private Integer state;

  private String desc;

  ElectronicAccountBankState(Integer state, String desc) {
    this.state = state;
    this.desc = desc;
  }

  public Integer getState() {
    return state;
  }

  public String getDesc() {
    return desc;
  }

}
