package com.bizunited.empower.business.payment.common.enums;

/**
 * 签约人类型: 1、企业法人，2：经办人
 * @Author: Paul Chan
 * @Date: 2021/4/8 下午4:19
 */
public enum ElectronicAccountSignerType {
  LEGAL_PERSON(1, "企业法人"),
  AGENT(2, "经办人");

  private Integer type;

  private String desc;

  ElectronicAccountSignerType(Integer type, String desc) {
    this.type = type;
    this.desc = desc;
  }

  public Integer getType() {
    return type;
  }

  public String getDesc() {
    return desc;
  }

  /**
   * 根据type值获取枚举
   * @param type
   * @return
   */
  public static ElectronicAccountSignerType valueOfType(Integer type) {
    if(type == null) {
      return null;
    }
    for (ElectronicAccountSignerType value : values()) {
      if(value.getType().equals(type)) {
        return value;
      }
    }
    return null;
  }

}
