package com.bizunited.empower.business.payment.common.enums;

/**
 * 电子账户状态
 * 状态：0：申请中，1：已启用，3：已冻结
 * @Author: Paul Chan
 * @Date: 2021/4/8 下午4:19
 */
public enum ElectronicAccountState {
  APPLYING(0, "申请中"),
  ENABLE(1, "已启用"),
  FROZEN(2, "已冻结");

  private Integer state;

  private String desc;

  ElectronicAccountState(Integer state, String desc) {
    this.state = state;
    this.desc = desc;
  }

  /**
   * 根据状态值获取枚举信息
   * @param state
   * @return
   */
  public static ElectronicAccountState valueOfState(Integer state) {
    if(state == null) {
      return null;
    }
    for (ElectronicAccountState value : values()) {
      if(value.state.equals(state)) {
        return value;
      }
    }
    return null;
  }

  public Integer getState() {
    return state;
  }

  public String getDesc() {
    return desc;
  }
}
