package com.bizunited.empower.business.payment.common.enums;

/**
 * 电子账户绑卡状态
 * @Author: Paul Chan
 * @Date: 2021/4/14 上午10:36
 */
public enum ElectronicAccountTiedCardStatus {
  UNTIED_CARD(1, "未绑卡-待绑卡"),
  TIED_PROCESSING(7, "绑卡处理中"),
  TIED_FAILURE(3, "绑卡失败"),
  WAIT_VERIFY(4, "待验证"),
  VERIFY_PROCESSING(8, "验证处理中"),
  VERIFY_FAILURE(5, "验证失败"),
  UNTIED_PROCESSING(6, "解绑处理中"),
  TIED_CARD(2, "已绑卡");

  private Integer status;

  private String desc;

  ElectronicAccountTiedCardStatus(Integer status, String desc) {
    this.status = status;
    this.desc = desc;
  }

  /**
   * 根据值获取枚举
   * @param status
   * @return
   */
  public static ElectronicAccountTiedCardStatus valueOfStatus(Integer status) {
    if(status == null) {
      return null;
    }
    for (ElectronicAccountTiedCardStatus value : values()) {
      if(value.status.equals(status)) {
        return value;
      }
    }
    return null;
  }

  public Integer getStatus() {
    return status;
  }

  public String getDesc() {
    return desc;
  }

}
