package com.bizunited.empower.business.payment.common.enums;

/**
 * 电子账户类型
 * 1、个体工商户，2：企业开户
 * @Author: Paul Chan
 * @Date: 2021/4/8 下午4:19
 */
public enum ElectronicAccountType {
  INDIVIDUAL(1, "个体工商户"),
  COMPANY(2, "企业开户");

  private Integer type;

  private String desc;

  ElectronicAccountType(Integer type, String desc) {
    this.type = type;
    this.desc = desc;
  }

  public Integer getType() {
    return type;
  }

  public String getDesc() {
    return desc;
  }

  /**
   * 根据type值获取枚举
   * @param type
   * @return
   */
  public static ElectronicAccountType valueOfType(Integer type) {
    if(type == null) {
      return null;
    }
    for (ElectronicAccountType value : values()) {
      if(value.getType().equals(type)) {
        return value;
      }
    }
    return null;
  }

}
