package com.bizunited.empower.business.payment.common.enums;

/**
 * 支付渠道
 * <p>
 * type  线上支付:1 线下支付:2
 *
 * @author Keller
 */
public enum FundsChannelType {
  ALIPAY(1, 1, "支付宝"),
  WECHAYPAY(2, 1, "微信小程序支付"),
  SANPAY(3, 2, "正扫码支付"),
  CASHPAY(4, 2, "现金支付"),
  TRANSFER(5, 2, "银行转账"),
  CREDITPAY(6, 2, "信用支付"),
  BALANCE(7,1,"中金余额支付"),
  ;

  FundsChannelType(Integer value, Integer type, String desc) {
    this.value = value;
    this.type = type;
    this.desc = desc;
  }

  Integer value;
  Integer type;
  String desc;

  /**
   * 收款方式枚举类型
   *
   * @param value
   * @return
   */
  public static FundsChannelType valueOfType(Integer value) {
    if (value == null) {
      return null;
    }
    for (FundsChannelType v : values()) {
      if (v.value.equals(value)) {
        return v;
      }
    }
    return null;
  }

  public Integer getValue() {
    return value;
  }

  public Integer getType() {
    return type;
  }

  public String getDesc() {
    return desc;
  }
}
