package com.bizunited.empower.business.payment.common.enums;


/**
 * 支付状态
 *
 * @author Keller
 */
public enum PayStatus {
  WAIT(1, "待处理"),
  SUCCESS(2, "成功"),
  FAILED(3, "失败"),
  ;

  PayStatus(Integer type, String desc){
    this.type = type;
    this.desc = desc;
  }
  /**
   * 类型
   */
  private Integer type;

  /**
   * 说明
   */
  private String desc;

  public Integer getType() {
    return type;
  }

  public String getDesc() {
    return desc;
  }

  /**
   * 支付状态加载
   *
   * @param type
   * @return
   */
  public static PayStatus load(Integer type) {
    if (type == null) {
      throw new IllegalArgumentException(String.format("支付状态为空，请检查！"));
    }
    for (PayStatus value : values()) {
      if (value.type.equals(type)) {
        return value;
      }
    }
    throw new IllegalArgumentException(String.format("错误的支付状态【%d】,请检查！", type));
  }
}
