package com.bizunited.empower.business.payment.common.enums;

/**
 * 客户电子钱包流水业务类型类型
 * 业务类型，1：提现、2：充值、3：转账结余、4：退货退款、5：应付单
 * @Author: Paul Chan
 * @Date: 2021/2/24 上午10:27
 */
public enum WalletBillBusinessType {
  WITHDRAW(1, "提现"),
  RECHARGE(2, "充值"),
  TRANSFER_BALANCE(3, "转账结余"),
  REFUND(4, "退货退款"),
  PAYMENT(5, "应付单");

  /**
   * 类型
   */
  private Integer type;

  /**
   * 说明
   */
  private String desc;

  WalletBillBusinessType(Integer type, String desc) {
    this.type = type;
    this.desc = desc;
  }

  /**
   * 根据流水单类型值获取相应的枚举
   * @param type
   * @return
   */
  public static WalletBillBusinessType valueOfType(Integer type) {
    if(type == null) {
      return null;
    }
    for (WalletBillBusinessType value : values()) {
      if(value.type.equals(type)) {
        return value;
      }
    }
    return null;
  }


  public Integer getType() {
    return type;
  }

  public String getDesc() {
    return desc;
  }
}
