package com.bizunited.empower.business.payment.controller;

import com.bizunited.empower.business.payment.entity.CustomerBank;
import com.bizunited.empower.business.payment.service.CustomerBankService;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * CustomerBank业务模型的MVC Controller层实现，基于HTTP Restful风格
 *
 * @author saturn
 */
@RestController
@Api(tags = "客户银行卡")
@RequestMapping("/v1/customerBank")
public class CustomerBankController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(CustomerBankController.class);

  @Autowired
  private CustomerBankService customerBankService;

  /**
   * 新增客户银行卡
   * @param customerBank
   * @return
   */
  @ApiOperation("新增客户银行卡")
  @PostMapping("")
  public ResponseModel create(@RequestBody @ApiParam("新增客户银行卡") CustomerBank customerBank) {
    try {
      customerBank = customerBankService.create(customerBank);
      return this.buildHttpResult(customerBank);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 相关的查询过程，http接口。通过主键进行数据的查询
   * */
  @ApiOperation(value = "相关的查询过程，http接口。通过主键进行数据的查询")
  @DeleteMapping(value="/{id}")
  public ResponseModel deleteById(@PathVariable("id") @ApiParam(name="id" , value="主键")String id){
    try {
      this.customerBankService.deleteById(id);
      return this.buildHttpResult();
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 根据客户编码查询客户的银行卡
   *
   * @param pageable
   * @param customerCode
   * @param tstatus
   * @return
   */
  @GetMapping("findByCustomerCode")
  @ApiOperation(value = "根据客户编码查询客户的银行卡", notes = "分页查询，分页参数为page和size，page从0开始，size默认50")
  public ResponseModel findByCustomerCode(@PageableDefault(50) Pageable pageable,
                                          @RequestParam @ApiParam("客户编码") String customerCode, @RequestParam(required = false) @ApiParam("状态") Integer tstatus) {
    try {
      Page<CustomerBank> page = customerBankService.findByCustomerCode(customerCode, tstatus, pageable);
      return this.buildHttpResultW(page);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

} 
