package com.bizunited.empower.business.payment.controller;

import com.bizunited.empower.business.payment.service.CustomerBankVoService;
import com.bizunited.empower.business.payment.vo.CustomerBankVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * BandCardVo业务模型的MVC Controller层实现，基于HTTP Restful风格
 *
 * @author Keller
 */
@RestController
@Api(tags = "银行卡信息")
@RequestMapping("/v1/customerBankVo")
public class CustomerBankVoController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(CustomerBankVoController.class);
  @Autowired
  private CustomerBankVoService customerBankVoService;
  /**
   * 按照银行卡号，通过中金接口获取银行卡类型信息
   *
   * @param cardNum
   */
  @GetMapping("findByCardNumber")
  @ApiOperation(value = "根据客户编码查询客户的银行卡", notes = "分页查询，分页参数为page和size，page从0开始，size默认50")
  public ResponseModel findByCardNumber(@RequestParam @ApiParam("银行卡号") String cardNum) {
    try {
      CustomerBankVo customerBankVo = customerBankVoService.findByCardNumner(cardNum);
      return this.buildHttpResult(customerBankVo);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }
}
