package com.bizunited.empower.business.payment.controller;

import com.bizunited.empower.business.payment.entity.CustomerCreditRecord;
import com.bizunited.empower.business.payment.service.CustomerCreditRecordService;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * CustomerCreditRecord业务模型的MVC Controller层实现，基于HTTP Restful风格
 * @author saturn
 */
@RestController
@Api(tags = "客户信用额度记录控制器")
@RequestMapping("/v1/customerCreditRecord")
public class CustomerCreditRecordController extends BaseController { 
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(CustomerCreditRecordController.class);
  
  @Autowired
  private CustomerCreditRecordService customerCreditRecordService;

  /**
   * 根据客户编码查询客户的信用额度变化记录
   * @param pageable
   * @param customerCode
   * @return
   */
  @GetMapping("findByCustomerCode")
  @ApiOperation(value = "根据客户编码查询客户的信用额度变化记录", notes = "分页查询，分页参数为page和size，page从0开始，size默认50")
  public ResponseModel findByCustomerCode(@PageableDefault(50) Pageable pageable,
                                          @RequestParam @ApiParam("客户编码") String customerCode) {
    try {
      Page<CustomerCreditRecord> page = customerCreditRecordService.findByCustomerCode(pageable, customerCode);
      return this.buildHttpResultW(page);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }


} 
