package com.bizunited.empower.business.payment.controller;

import com.bizunited.empower.business.payment.service.CustomerFundsVoService;
import com.bizunited.empower.business.payment.vo.CustomerFundsVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * CustomerFundsBillVo业务模型的MVC Controller层实现，基于HTTP Restful风格
 *
 * @author Keller
 */
@RestController
@Api(tags = "客户流水信息控制器")
@RequestMapping("/v1/customerFundsVo")
public class CustomerFundsVoController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(CustomerFundsVoController.class);
  @Autowired
  private CustomerFundsVoService customerFundsVoService;

  /**
   * 根据客户传递的时间查询流水信息
   * @param startTime 开始时间
   * @param endTime   结束时间
   * @return
   */
  @GetMapping("findByTimes")
  @ApiOperation(value = "根据客户传递的时间查询流水信息")
  public ResponseModel findByConditions(@RequestParam @ApiParam("开始时间") String startTime,
                                        @RequestParam @ApiParam("结束时间") String endTime,
                                        @RequestParam @ApiParam("类型 1、全部 2、支付 3、收款") Integer type) {
    try {
      CustomerFundsVo customerFundsVo = customerFundsVoService.findByTimes(startTime, endTime, type);
      return this.buildHttpResultW(customerFundsVo,"customerFundsBillVos");
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

}
