package com.bizunited.empower.business.payment.controller;

import com.bizunited.empower.business.payment.entity.CustomerWalletBill;
import com.bizunited.empower.business.payment.service.CustomerWalletBillService;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * CustomerWalletBill业务模型的MVC Controller层实现，基于HTTP Restful风格
 * @author saturn
 */
@RestController
@RequestMapping("/v1/customerWalletBill")
public class CustomerWalletBillController extends BaseController { 
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(CustomerWalletBillController.class);
  
  @Autowired
  private CustomerWalletBillService customerWalletBillService;

  /**
   * 根据客户编码和条件查询客户的交易记录
   * @return
   */
  @GetMapping("findByCustomerCodeAndConditions")
  @ApiOperation(value = "根据客户编码和条件查询客户的交易记录", notes = "分页查询，分页参数为page和size，page从0开始，size默认50")
  public ResponseModel findByCustomerCodeAndConditions(@PageableDefault(50) Pageable pageable,
                                                       @RequestParam @ApiParam(value = "客户编码", required = true) String customerCode,
                                                       @RequestParam(required = false) @ApiParam("交易类型，1：收款 2：恢复余额") Integer type) {
    try {
      Map<String, Object> conditions = Maps.newHashMap();
      conditions.put("type", type);
      Page<CustomerWalletBill> page = customerWalletBillService.findByCustomerCodeAndConditions(customerCode, pageable, conditions);
      return this.buildHttpResultW(page);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

} 
