package com.bizunited.empower.business.payment.controller;

import com.bizunited.empower.business.payment.service.CustomerWalletStatisticsVoService;
import com.bizunited.empower.business.payment.vo.CustomerWalletStatisticsVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 客户电子钱包统计控制器
 * @Author: Paul Chan
 * @Date: 2021/4/13 下午6:20
 */
@Api
@RestController
@RequestMapping("/v1/customer/wallet/statistics")
public class CustomerWalletStatisticsVoController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(CustomerWalletStatisticsVoController.class);

  @Autowired
  private CustomerWalletStatisticsVoService customerWalletStatisticsVoService;

  /**
   * 查询当前经销商的统计信息
   * @return
   */
  @GetMapping("findByTenant")
  @ApiOperation("查询当前经销商的统计信息")
  public ResponseModel findByTenant() {
    try {
      CustomerWalletStatisticsVo vo = customerWalletStatisticsVoService.findByTenant();
      return this.buildHttpResultW(vo);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

}
