package com.bizunited.empower.business.payment.controller;

import com.bizunited.empower.business.payment.service.CustomerWalletVoService;
import com.bizunited.empower.business.payment.vo.CustomerWalletVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * CustomerWalletVO业务模型的MVC Controller层实现，基于HTTP Restful风格
 * @Author: Paul Chan
 * @Date: 2021/4/13 下午3:12
 */
@RestController
@RequestMapping("/v1/customerWalletVo")
public class CustomerWalletVoController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(CustomerWalletVoController.class);

  @Autowired
  private CustomerWalletVoService customerWalletVoService;

  /**
   * 多条件分页查询
   * */
  @GetMapping("/findByConditions")
  @ApiOperation(value = "多条件分页查询", notes = "分页查询，分页参数为page和size，page从0开始，size默认50")
  public ResponseModel findByConditions(@PageableDefault(50) Pageable pageable,
                                        @RequestParam(required = false) @ApiParam("搜索关键字") String keyword){
    try {
      Map<String, Object> conditions = Maps.newHashMap();
      conditions.put("keyword", keyword);
      Page<CustomerWalletVo> page = this.customerWalletVoService.findByConditions(conditions, pageable);
      return this.buildHttpResultW(page);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

}
